/*
 * Decompiled with CFR 0.152.
 */
package de.monochromata.cucumber.report;

import de.monochromata.cucumber.report.config.ConfigurationFactory;
import io.cucumber.core.plugin.JSONFormatter;
import io.cucumber.plugin.EventListener;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.TestRunFinished;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportBuilder;

public class PrettyReports
implements Plugin,
EventListener {
    private final File outputDir;
    private final File jsonFile;
    private final EventListener delegateJsonEventListener;

    public PrettyReports() throws Exception {
        this(new File("target" + File.separator + "cucumber"));
    }

    public PrettyReports(File outputDir) throws Exception {
        this(outputDir, PrettyReports.createTempFileDeletedOnExit());
    }

    protected PrettyReports(File outputDir, File jsonFile) throws Exception {
        this(outputDir, jsonFile, PrettyReports.createJsonEventListener(jsonFile));
    }

    protected PrettyReports(File outputDir, File jsonFile, EventListener delegateJsonEventListener) throws Exception {
        this.outputDir = outputDir;
        this.jsonFile = jsonFile;
        this.delegateJsonEventListener = delegateJsonEventListener;
    }

    protected static File createTempFileDeletedOnExit() throws IOException {
        File jsonFile = File.createTempFile("cucumber", ".json");
        jsonFile.deleteOnExit();
        return jsonFile;
    }

    protected static EventListener createJsonEventListener(File jsonFile) {
        try {
            OutputStreamWriter appendable = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), StandardCharsets.UTF_8);
            return new JSONFormatter((Appendable)appendable);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void setEventPublisher(EventPublisher publisher) {
        this.delegateJsonEventListener.setEventPublisher(publisher);
        publisher.registerHandlerFor(TestRunFinished.class, this.generatePrettyReport(this.jsonFile));
    }

    protected EventHandler<TestRunFinished> generatePrettyReport(File jsonFile) {
        return unused -> PrettyReports.generatePrettyReport(jsonFile, this.outputDir);
    }

    protected static void generatePrettyReport(File jsonFile, File outputDir) {
        Configuration configuration = ConfigurationFactory.getConfiguration(outputDir);
        new ReportBuilder(Collections.singletonList(jsonFile.getAbsolutePath()), configuration).generateReports();
    }
}

