/*
 * Decompiled with CFR 0.152.
 */
package de.monochromata.cucumber.report;

import cucumber.api.Plugin;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.runtime.formatter.PluginFactory;
import de.monochromata.cucumber.report.config.ConfigurationFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportBuilder;

public class PrettyReports
implements Plugin,
EventListener {
    private final File outputDir;
    private final File jsonFile;
    private final EventListener delegateJsonEventListener;

    public PrettyReports() throws Exception {
        this(new File("target" + File.separator + "cucumber"));
    }

    public PrettyReports(File outputDir) throws Exception {
        this(outputDir, PrettyReports.createTempFileDeletedOnExit());
    }

    protected PrettyReports(File outputDir, File jsonFile) throws Exception {
        this(outputDir, jsonFile, PrettyReports.createJsonEventListener(jsonFile));
    }

    protected PrettyReports(File outputDir, File jsonFile, EventListener delegateJsonEventListener) throws Exception {
        this.outputDir = outputDir;
        this.jsonFile = jsonFile;
        this.delegateJsonEventListener = delegateJsonEventListener;
    }

    protected static File createTempFileDeletedOnExit() throws IOException {
        File jsonFile = File.createTempFile("cucumber", ".json");
        jsonFile.deleteOnExit();
        return jsonFile;
    }

    protected static EventListener createJsonEventListener(File jsonFile) {
        return (EventListener)new PluginFactory().create("json:" + jsonFile.getAbsolutePath());
    }

    public void setEventPublisher(EventPublisher publisher) {
        this.delegateJsonEventListener.setEventPublisher(publisher);
        publisher.registerHandlerFor(TestRunFinished.class, this.generatePrettyReport(this.jsonFile));
    }

    protected EventHandler<TestRunFinished> generatePrettyReport(File jsonFile) {
        return unused -> PrettyReports.generatePrettyReport(jsonFile, this.outputDir);
    }

    protected static void generatePrettyReport(File jsonFile, File outputDir) {
        Configuration configuration = ConfigurationFactory.getConfiguration(outputDir);
        new ReportBuilder(Collections.singletonList(jsonFile.getAbsolutePath()), configuration).generateReports();
    }
}

