/*
 * Decompiled with CFR 0.152.
 */
package de.monochromata.cucumber.report.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Properties;
import net.masterthought.cucumber.Configuration;

public class ConfigurationFactory {
    private static final String DEFAULT_FILENAME = "cucumber-reporting.properties";
    private static final String CLASSIFICATIONS_PREFIX = "classifications.";
    public static final String CONFIG_FILE_PROPERTY = "cucumber.reporting.config.file";

    public static Configuration getConfiguration(File outputDir) {
        Properties properties = ConfigurationFactory.loadProperties();
        String projectName = properties.getProperty("projectName", "No Name (add projectName to cucumber-reporting.properties)");
        Configuration configuration = new Configuration(outputDir, projectName);
        ConfigurationFactory.configureParallelTesting(configuration, properties);
        ConfigurationFactory.configureRunWithJenkins(configuration, properties);
        ConfigurationFactory.configureBuildNumber(configuration, properties);
        ConfigurationFactory.configureClassifications(configuration, properties);
        return configuration;
    }

    protected static void configureParallelTesting(Configuration configuration, Properties properties) {
        configuration.setParallelTesting(Boolean.parseBoolean(properties.getProperty("parallelTesting", "false")));
    }

    protected static void configureRunWithJenkins(Configuration configuration, Properties properties) {
        configuration.setRunWithJenkins(Boolean.parseBoolean(properties.getProperty("runWithJenkins", "false")));
    }

    protected static void configureBuildNumber(Configuration configuration, Properties properties) {
        configuration.setBuildNumber(properties.getProperty("buildNumber"));
    }

    protected static void configureClassifications(Configuration configuration, Properties properties) {
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String qualifiedKey = (String)keys.nextElement();
            if (!qualifiedKey.startsWith(CLASSIFICATIONS_PREFIX)) continue;
            String key = qualifiedKey.substring(CLASSIFICATIONS_PREFIX.length());
            configuration.addClassifications(key, properties.getProperty(qualifiedKey));
        }
    }

    protected static Properties loadProperties() {
        Properties properties = new Properties();
        InputStream stream = ConfigurationFactory.getPropertiesStream();
        if (stream != null) {
            try {
                properties.load(new InputStreamReader(stream, "UTF-8"));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return properties;
    }

    protected static InputStream getPropertiesStream() {
        String filename = ConfigurationFactory.getPropertiesFilename();
        File propertiesFile = Optional.ofNullable(Paths.get(filename, new String[0]).toFile()).filter(File::exists).filter(File::isFile).filter(File::canRead).orElse(null);
        if (propertiesFile == null && !filename.equals(DEFAULT_FILENAME)) {
            throw new UncheckedIOException(new FileNotFoundException("Cucumber reporting properties file " + filename + " was not found"));
        }
        if (propertiesFile != null) {
            try {
                return new FileInputStream(propertiesFile);
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(e);
            }
        }
        return null;
    }

    protected static String getPropertiesFilename() {
        return System.getProperty(CONFIG_FILE_PROPERTY, DEFAULT_FILENAME);
    }
}

