/*
 * Decompiled with CFR 0.152.
 */
package de.monochromata.cucumber.report;

import cucumber.api.Plugin;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.api.formatter.Formatter;
import cucumber.runtime.formatter.PluginFactory;
import de.monochromata.cucumber.report.config.ConfigurationFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportBuilder;

public class PrettyReports
implements Plugin,
Formatter {
    private final File outputDir;
    private final File jsonFile;
    private final Formatter delegateJsonFormatter;

    public PrettyReports() throws Exception {
        this(new File("target" + File.separator + "cucumber"));
    }

    public PrettyReports(File outputDir) throws Exception {
        this.outputDir = outputDir;
        this.jsonFile = this.createTempFileDeletedOnExit();
        this.delegateJsonFormatter = PrettyReports.createJsonFormatter(this.jsonFile);
    }

    protected File createTempFileDeletedOnExit() throws IOException {
        File jsonFile = File.createTempFile("cucumber", ".json");
        jsonFile.deleteOnExit();
        return jsonFile;
    }

    protected static Formatter createJsonFormatter(File jsonFile) throws Exception {
        return (Formatter)new PluginFactory().create("json:" + jsonFile.getAbsolutePath());
    }

    public void setEventPublisher(EventPublisher publisher) {
        this.delegateJsonFormatter.setEventPublisher(publisher);
        publisher.registerHandlerFor(TestRunFinished.class, this::generatePrettyReport);
    }

    protected void generatePrettyReport(TestRunFinished event) {
        Configuration configuration = ConfigurationFactory.getConfiguration(this.outputDir);
        new ReportBuilder(Collections.singletonList(this.jsonFile.getAbsolutePath()), configuration).generateReports();
    }
}

