package de.monochromata.cucumber.report;

import static java.io.File.createTempFile;
import static java.util.Collections.singletonList;

import java.io.File;
import java.io.IOException;

import cucumber.api.Plugin;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.api.formatter.Formatter;
import cucumber.runtime.formatter.PluginFactory;
import de.monochromata.cucumber.report.config.ConfigurationFactory;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportBuilder;

public class PrettyReports implements Plugin, Formatter {

    private final File outputDir;
    private final File jsonFile;
    private final Formatter delegateJsonFormatter;

    public PrettyReports() throws Exception {
        this(new File("target" + File.separator + "cucumber"));
    }

    public PrettyReports(final File outputDir) throws Exception {
        this.outputDir = outputDir;
        jsonFile = createTempFileDeletedOnExit();
        delegateJsonFormatter = createJsonFormatter(jsonFile);
    }

    protected File createTempFileDeletedOnExit() throws IOException {
        final File jsonFile = createTempFile("cucumber", ".json");
        jsonFile.deleteOnExit();
        return jsonFile;
    }

    protected static Formatter createJsonFormatter(final File jsonFile)
            throws Exception {
        return (Formatter) new PluginFactory().create("json:" + jsonFile.getAbsolutePath());
    }

    @Override
    public void setEventPublisher(final EventPublisher publisher) {
        delegateJsonFormatter.setEventPublisher(publisher);
        publisher.registerHandlerFor(TestRunFinished.class, this::generatePrettyReport);
    }

    protected void generatePrettyReport(final TestRunFinished event) {
        final Configuration configuration = ConfigurationFactory.getConfiguration(outputDir);
        new ReportBuilder(singletonList(jsonFile.getAbsolutePath()), configuration).generateReports();
    }
}
