package de.monochromata.anaphors.ast.relatedexp;

import java.util.List;

import de.monochromata.anaphors.ast.relatedexp.strategy.RelatedExpressionStrategy;

/**
 * An interface to objects used to traverse the AST to find potential related
 * expressions.
 * <p>
 * Note that the implementations of this interface may choose to support only a
 * fixed set of {@link RelatedExpressionStrategy} instances.
 *
 * @param <N>  The node type in the AST
 * @param <E>  The expression type
 * @param <T>  The type type
 * @param <B>  The binding type
 * @param <TB> The type binding type
 * @param <S>  The scope type (optional)
 * @param <QI> The type used to represent qualified identifiers
 * @param <R>  The sub-type of related expression to use
 */
public interface RelatedExpressionsCollector<N, E, T, B, TB extends B, S, QI, R extends RelatedExpression<N, T, B, TB, S, QI, R>> {

	/**
	 * Traverse the body declaration that contains the given definite expression.
	 * <p>
	 * TODO: Rename the method to make clear that the enclosing body declaration is
	 * to be traversed?
	 * <p>
	 * TODO: There might be related expression that do not traverse the body
	 * enclosing the given definite expression but that check whether that body is
	 * reachable from some place
	 *
	 * @param definiteExpression The definite expression whose enclosing body is to
	 *                           be traversed.
	 * @param scope              The scope containing the definite expression if
	 *                           used by the compiler-specific implementation.
	 *                           Implementations of this method must not access the
	 *                           scope but merely pass it on to SPI's they invoke.
	 * @return collected potential related expressions
	 */
	public List<R> traverse(E definiteExpression, S scope);
}
