/*
 * Decompiled with CFR 0.152.
 */
package de.mobanisto.toast4j;

import de.mobanisto.toast4j.ToastHandle;
import de.mobanisto.wintoast.Aumi;
import de.mobanisto.wintoast.WinToast;
import de.mobanisto.wintoast.WinToastHandler;
import de.mobanisto.wintoast.WinToastTemplate;
import org.bytedeco.javacpp.CharPointer;
import org.bytedeco.javacpp.IntPointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Toaster {
    static final Logger logger = LoggerFactory.getLogger(Toaster.class);
    private final WinToast winToast;
    private final String aumi;
    private final WinToastHandler defaultWinToastHandler = new WinToastHandler(){

        @Override
        public void toastActivated() {
            logger.debug("toast activated");
        }

        @Override
        public void toastActivated(int actionIndex) {
            logger.debug("toast activated: " + actionIndex);
        }

        @Override
        public void toastDismissed(int state) {
            logger.debug("toast dismissed: " + state);
        }

        @Override
        public void toastFailed() {
            logger.warn("toast failed");
        }
    };

    public static Toaster forAumi(String aumi) {
        return new Toaster(aumi);
    }

    public static Toaster forAumi(Aumi aumi) {
        return new Toaster(aumi);
    }

    public static Toaster forAppName(String appName) {
        return new Toaster(new AppName(appName));
    }

    private Toaster(AppName appName) {
        this.winToast = WinToast.instance();
        try (CharPointer pAppName = new CharPointer(appName.appName);
             CharPointer pAumiResult = new CharPointer();){
            boolean aumiFound = this.winToast.getAumiFromShellLink(pAppName, pAumiResult);
            if (!aumiFound) {
                throw new IllegalArgumentException(String.format("Invalid app '%s'", appName));
            }
            this.aumi = pAumiResult.getString();
        }
    }

    private Toaster(String aumi) {
        this.aumi = aumi;
        this.winToast = WinToast.instance();
    }

    private Toaster(Aumi aumi) {
        this.winToast = WinToast.instance();
        try (CharPointer pCompanyName = new CharPointer(aumi.getCompanyName());
             CharPointer pProductName = new CharPointer(aumi.getProductName());
             CharPointer pSubProduct = new CharPointer(aumi.getSubProduct());
             CharPointer pVersionInformation = new CharPointer(aumi.getVersionInformation());){
            CharPointer aumiResult = this.winToast.configureAUMI(pCompanyName, pProductName, pSubProduct, pVersionInformation);
            this.aumi = aumiResult.getString();
            logger.info("aumi: " + aumi);
        }
    }

    public boolean initialize() {
        boolean success = this.winToast.initialize();
        logger.info("initialize: " + success);
        return success;
    }

    public ToastHandle showToast(WinToastTemplate template) {
        return this.showToast(template, null);
    }

    public ToastHandle showToast(WinToastTemplate template, WinToastHandler handler) {
        WinToastHandler h = handler != null ? handler : this.defaultWinToastHandler;
        IntPointer errorCode = new IntPointer(0L);
        try (CharPointer pAumi = new CharPointer(this.aumi);){
            long uid = this.winToast.showToast(pAumi, template, h, errorCode);
            logger.debug("toast uid: " + uid);
            logger.debug("error code: " + this.winToast.strerror(errorCode.get()).getString());
            ToastHandle toastHandle = new ToastHandle(this, uid);
            return toastHandle;
        }
    }

    public void hideToast(long uid) {
        try (CharPointer pAumi = new CharPointer(this.aumi);){
            this.winToast.hideToast(pAumi, uid);
        }
    }

    public boolean doesShellLinkExist(String appName) {
        return this.winToast.doesShellLinkExist(new CharPointer(appName));
    }

    public String getAumiFromShellLink(String appName) {
        try (CharPointer pAppName = new CharPointer(appName);
             CharPointer pAumiResult = new CharPointer();){
            boolean success = this.winToast.getAumiFromShellLink(pAppName, pAumiResult);
            if (success) {
                String string = pAumiResult.getString();
                return string;
            }
        }
        return null;
    }

    public void initializeShortcut(String appName, boolean updateExisting) {
        try (CharPointer pAppName = new CharPointer(appName);
             CharPointer pAumi = new CharPointer(this.aumi);){
            this.winToast.initializeShortcut(pAppName, pAumi, updateExisting);
        }
    }

    public void setProcessAumi() {
        try (CharPointer pAumi = new CharPointer();){
            this.winToast.setProcessAumi(pAumi);
        }
    }

    private static class AppName {
        private final String appName;

        public AppName(String appName) {
            this.appName = appName;
        }
    }
}

