/*
 * Decompiled with CFR 0.152.
 */
package de.mobanisto.toast4j;

import de.mobanisto.wintoast.WinToastTemplate;
import org.bytedeco.javacpp.CharPointer;

public class ToastBuilder {
    private WinToastTemplate.WinToastTemplateType type = null;
    private String line1 = null;
    private String line2 = null;
    private String line3 = null;
    private String image = null;
    private String attribution = null;
    private int audioOption = 0;
    private int expiration = 0;

    public ToastBuilder(WinToastTemplate.WinToastTemplateType type) {
        this.type = type;
    }

    public WinToastTemplate build() {
        WinToastTemplate winToastTemplate = new WinToastTemplate(this.type.getId());
        if (this.type.getNumTextFields() >= 1 && this.line1 != null) {
            winToastTemplate.setTextField(new CharPointer(this.line1), 0);
        }
        if (this.type.getNumTextFields() >= 2 && this.line2 != null) {
            winToastTemplate.setTextField(new CharPointer(this.line2), 1);
        }
        if (this.type.getNumTextFields() >= 3 && this.line3 != null) {
            winToastTemplate.setTextField(new CharPointer(this.line3), 2);
        }
        if (this.attribution != null) {
            winToastTemplate.setAttributionText(new CharPointer(this.attribution));
        }
        if (this.image != null) {
            winToastTemplate.setImagePath(new CharPointer(this.image));
        }
        winToastTemplate.setAudioOption(this.audioOption);
        winToastTemplate.setExpiration(this.expiration);
        return winToastTemplate;
    }

    public ToastBuilder setType(WinToastTemplate.WinToastTemplateType type) {
        this.type = type;
        return this;
    }

    public ToastBuilder setLine1(String line) {
        this.line1 = line;
        return this;
    }

    public ToastBuilder setLine2(String line) {
        this.line2 = line;
        return this;
    }

    public ToastBuilder setLine3(String line) {
        this.line3 = line;
        return this;
    }

    public ToastBuilder setImage(String image) {
        this.image = image;
        return this;
    }

    public ToastBuilder setDefaultAudio() {
        return this.setAudioOption(0);
    }

    public ToastBuilder setSilent() {
        return this.setAudioOption(1);
    }

    public ToastBuilder setLoopAudio() {
        return this.setAudioOption(2);
    }

    private ToastBuilder setAudioOption(int audioOption) {
        this.audioOption = audioOption;
        return this;
    }

    public ToastBuilder setExpiration(int expiration) {
        this.expiration = expiration;
        return this;
    }
}

