/*
 * Decompiled with CFR 0.152.
 */
package de.mlo.dev.validation.value;

import de.mlo.dev.validation.value.ValueValidationResult;
import de.mlo.dev.validation.value.ValueValidationRunner;
import de.mlo.dev.validation.value.ValueValidationRunners;
import de.mlo.dev.validation.value.ValueValidationStatement;
import de.mlo.dev.validation.value.ValueValidationSummarizer;
import de.mlo.dev.validation.value.ValueValidatorGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueValidator<V>
implements ValueValidationSummarizer<V> {
    private final List<ValueValidationSummarizer<V>> aggregators = new ArrayList<ValueValidationSummarizer<V>>();
    private ValueValidationRunner<V> validationRunner = ValueValidationRunners::validateAll;

    public static <V> ValueValidator<V> create(Class<V> type) {
        return new ValueValidator<V>();
    }

    @NotNull
    public ValueValidator<V> add(@Nullable ValueValidationStatement<V> statement) {
        return this.add((ValueValidationSummarizer<V>)statement);
    }

    @NotNull
    public ValueValidator<V> add(@Nullable ValueValidationSummarizer<V> validationSummarizer) {
        if (validationSummarizer != null) {
            this.aggregators.add(validationSummarizer);
        }
        return this;
    }

    public ValueValidatorGroup<V> groupBuilder() {
        return new ValueValidatorGroup(this);
    }

    @Override
    @NotNull
    public ValueValidationResult<V> validate(V value) {
        return this.validationRunner.validate(value, this.aggregators);
    }

    @NotNull
    public ValueValidationResult<V> validateStopOnFirstFail(V value) {
        return this.setValidateStopOnFirstFail().validate((Object)value);
    }

    @NotNull
    public ValueValidator<V> setValidateAll() {
        return this.setValidationRunner(ValueValidationRunners::validateAll);
    }

    @NotNull
    public ValueValidator<V> setValidateStopOnFirstFail() {
        return this.setValidationRunner(ValueValidationRunners::validateStopOnFirstFail);
    }

    @NotNull
    public ValueValidator<V> setValidationRunner(@NotNull ValueValidationRunner<V> validationRunner) {
        this.validationRunner = Objects.requireNonNull(validationRunner);
        return this;
    }

    ValueValidator<V> build() {
        return this;
    }
}

