/*
 * Decompiled with CFR 0.152.
 */
package de.mlo.dev.validation.value;

import de.mlo.dev.validation.basic.ValidationResult;
import de.mlo.dev.validation.value.ValueValidationResult;
import de.mlo.dev.validation.value.ValueValidationSummarizer;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ValueValidationRunners {
    private static final Logger LOGGER = LogManager.getLogger((String)ValueValidationRunners.class.getName());

    private ValueValidationRunners() {
    }

    @NotNull
    static <V> ValueValidationResult<V> validateAll(V value, List<ValueValidationSummarizer<V>> instructions) {
        LOGGER.debug("Start validating {} instructions", (Object)instructions.size());
        ValueValidationResult<V> result = new ValueValidationResult<V>(value);
        for (int i = 0; i < instructions.size(); ++i) {
            ValidationResult info = instructions.get(i).validate(value);
            result.add(info);
            if (!info.isInvalid()) continue;
            LOGGER.debug("Validation failed: Instruction number {} | message: {}", (Object)i, (Object)info.getMessage());
        }
        if (result.isInvalid()) {
            LOGGER.debug("Validation was successful");
        } else {
            LOGGER.debug("Validation failed");
        }
        return result;
    }

    @NotNull
    static <V> ValueValidationResult<V> validateStopOnFirstFail(V value, List<ValueValidationSummarizer<V>> instructions) {
        LOGGER.debug("Start validating {} instructions", (Object)instructions.size());
        ValueValidationResult<V> result = new ValueValidationResult<V>(value);
        for (int i = 0; i < instructions.size(); ++i) {
            ValidationResult info = instructions.get(i).validate(value);
            result.add(info);
            if (result.isInvalid()) {
                LOGGER.debug("Validation failed: Instruction number {} | message: {}", (Object)(i + 1), (Object)info.getMessage());
                return result;
            }
            LOGGER.debug("Instruction number {} passed", (Object)(i + 1));
        }
        LOGGER.debug("Validation was successful");
        return result;
    }
}

