/*
 * Decompiled with CFR 0.152.
 */
package de.mlo.dev.validation.basic;

import de.mlo.dev.validation.basic.ValidationResult;
import de.mlo.dev.validation.basic.ValidationRunner;
import de.mlo.dev.validation.basic.ValidationRunners;
import de.mlo.dev.validation.basic.ValidationStatement;
import de.mlo.dev.validation.basic.ValidationSummarizer;
import de.mlo.dev.validation.basic.ValidatorGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Validator
implements ValidationSummarizer {
    private final List<ValidationSummarizer> aggregators = new ArrayList<ValidationSummarizer>();
    private ValidationRunner validationRunner = ValidationRunners.VALIDATE_ALL;

    @NotNull
    public Validator add(@Nullable ValidationStatement statement) {
        return this.add((ValidationSummarizer)statement);
    }

    @NotNull
    public Validator add(@Nullable ValidationSummarizer validationSummarizer) {
        if (validationSummarizer != null) {
            this.aggregators.add(validationSummarizer);
        }
        return this;
    }

    public ValidatorGroup groupBuilder() {
        return new ValidatorGroup(this);
    }

    @Override
    @NotNull
    public ValidationResult validate() {
        return this.validationRunner.validate(this.aggregators);
    }

    @NotNull
    public ValidationResult validateStopOnFirstFail() {
        return this.setValidateStopOnFirstFail().validate();
    }

    @NotNull
    public Validator setValidateAll() {
        return this.setValidationRunner(ValidationRunners.VALIDATE_ALL);
    }

    @NotNull
    public Validator setValidateStopOnFirstFail() {
        return this.setValidationRunner(ValidationRunners.VALIDATE_STOP_ON_FIRST_FAIL);
    }

    @NotNull
    public Validator setValidationRunner(@NotNull ValidationRunner validationRunner) {
        this.validationRunner = Objects.requireNonNull(validationRunner);
        return this;
    }

    Validator build() {
        return this;
    }
}

