/*
 * Decompiled with CFR 0.152.
 */
package de.mlo.dev.validation.basic;

import de.mlo.dev.validation.basic.ValidationResult;
import de.mlo.dev.validation.basic.ValidationRunner;
import de.mlo.dev.validation.basic.ValidationSummarizer;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ValidationRunners {
    private static final Logger LOGGER = LogManager.getLogger((String)ValidationRunners.class.getName());
    public static final ValidationRunner VALIDATE_ALL = ValidationRunners::validateAll;
    public static final ValidationRunner VALIDATE_STOP_ON_FIRST_FAIL = ValidationRunners::validateStopOnFirstFail;

    private ValidationRunners() {
    }

    @NotNull
    private static ValidationResult validateAll(List<ValidationSummarizer> instructions) {
        LOGGER.debug("Start validating {} instructions", (Object)instructions.size());
        ValidationResult result = new ValidationResult();
        for (int i = 0; i < instructions.size(); ++i) {
            ValidationResult info = instructions.get(i).validate();
            result.add(info);
            if (!info.isInvalid()) continue;
            LOGGER.debug("Validation failed: Instruction number {} | message: {}", (Object)i, (Object)info.getMessage());
        }
        if (result.isInvalid()) {
            LOGGER.debug("Validation was successful");
        } else {
            LOGGER.debug("Validation failed");
        }
        return result;
    }

    @NotNull
    private static ValidationResult validateStopOnFirstFail(List<ValidationSummarizer> instructions) {
        LOGGER.debug("Start validating {} instructions", (Object)instructions.size());
        ValidationResult result = new ValidationResult();
        for (int i = 0; i < instructions.size(); ++i) {
            ValidationResult info = instructions.get(i).validate();
            result.add(info);
            if (result.isInvalid()) {
                LOGGER.debug("Validation failed: Instruction number {} | message: {}", (Object)(i + 1), (Object)info.getMessage());
                return result;
            }
            LOGGER.debug("Instruction number {} passed", (Object)(i + 1));
        }
        LOGGER.debug("Validation was successful");
        return result;
    }
}

