/*
 * Decompiled with CFR 0.152.
 */
package de.mlo.dev.validation.basic;

import de.mlo.dev.validation.ValidationInfo;
import de.mlo.dev.validation.ValidationMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;

public class ValidationResult
implements Iterable<ValidationInfo> {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final List<ValidationInfo> infos = new ArrayList<ValidationInfo>();
    private boolean valid = true;

    public static ValidationResult invalid(String message) {
        return new ValidationResult().add(ValidationInfo.invalid(message));
    }

    public ValidationResult add(ValidationResult validationResult) {
        return this.add(validationResult.infos);
    }

    public ValidationResult add(ValidationInfo first, ValidationInfo ... more) {
        this.add(first);
        for (ValidationInfo info : more) {
            this.add(info);
        }
        return this;
    }

    public ValidationResult add(Collection<ValidationInfo> validationInfos) {
        for (ValidationInfo info : validationInfos) {
            this.add(info);
        }
        return this;
    }

    public ValidationResult add(ValidationInfo validationInfo) {
        if (validationInfo != null) {
            this.infos.add(validationInfo);
            this.valid = this.valid && validationInfo.isValid();
        }
        return this;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isInvalid() {
        return !this.valid;
    }

    public List<ValidationInfo> getInfos() {
        return new ArrayList<ValidationInfo>(this.infos);
    }

    public String getMessage() {
        return this.getMessage(LINE_SEPARATOR);
    }

    public String getMessage(String delimiter) {
        return this.infos.stream().map(ValidationInfo::getMessage).map(ValidationMessage::getText).filter(Objects::nonNull).collect(Collectors.joining(delimiter));
    }

    public List<ValidationMessage> getMessages() {
        return this.infos.stream().map(ValidationInfo::getMessage).filter(ValidationMessage::isNotEmpty).collect(Collectors.toList());
    }

    public List<String> getMessagesTextList() {
        return this.infos.stream().map(ValidationInfo::getMessageText).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Set<String> getCodes() {
        return this.infos.stream().map(ValidationInfo::getMessage).map(ValidationMessage::getCode).filter(Objects::nonNull).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public Iterator<ValidationInfo> iterator() {
        return this.infos.iterator();
    }

    @Generated
    public String toString() {
        return "ValidationResult(infos=" + this.getInfos() + ", valid=" + this.isValid() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationResult)) {
            return false;
        }
        ValidationResult other = (ValidationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isValid() != other.isValid()) {
            return false;
        }
        List<ValidationInfo> this$infos = this.getInfos();
        List<ValidationInfo> other$infos = other.getInfos();
        return !(this$infos == null ? other$infos != null : !((Object)this$infos).equals(other$infos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ValidationResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isValid() ? 79 : 97);
        List<ValidationInfo> $infos = this.getInfos();
        result = result * 59 + ($infos == null ? 43 : ((Object)$infos).hashCode());
        return result;
    }
}

