/*
 * Decompiled with CFR 0.152.
 */
package de.mlo.dev.validation;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValidationMessage
implements Comparable<ValidationMessage> {
    private static final ValidationMessage EMPTY = new ValidationMessage(null, null, new Object[0]);
    private static final Object[] EMPTY_PARAMETERS = new Object[0];
    private final String text;
    private final Object[] parameters;
    private final String code;

    public ValidationMessage(@Nullable String code, @Nullable String text, Object ... parameters) {
        this.code = code;
        this.text = text;
        this.parameters = Objects.requireNonNullElse(parameters, EMPTY_PARAMETERS);
    }

    @NotNull
    public static ValidationMessage of(@Nullable String code, @Nullable String text) {
        return new ValidationMessage(code, text, new Object[0]);
    }

    @NotNull
    public static ValidationMessage empty() {
        return EMPTY;
    }

    @NotNull
    public static ValidationMessage justCode(@Nullable String code) {
        return ValidationMessage.of(code, null);
    }

    @NotNull
    public static ValidationMessage justText(@Nullable String text) {
        return ValidationMessage.of(null, text);
    }

    @NotNull
    public static ValidationMessage formattedText(@NotNull String text, Object ... args) {
        return ValidationMessage.formatted(null, text, args);
    }

    @NotNull
    public static ValidationMessage formatted(@Nullable String code, @NotNull String text, Object ... args) {
        return new ValidationMessage(code, text, args);
    }

    private static String format(String format, Object ... args) {
        if (args == null || format == null) {
            return format;
        }
        String msg = String.format(format, args);
        msg = MessageFormat.format(msg, args);
        return msg;
    }

    @Nullable
    public String getText() {
        return ValidationMessage.format(this.text, this.parameters);
    }

    @Nullable
    public String getUnformattedText() {
        return this.text;
    }

    @NotNull
    public Object[] getParameters() {
        return this.parameters;
    }

    @Nullable
    public String getCode() {
        return this.code;
    }

    public boolean isEmpty() {
        return this.code == null && this.text == null;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public String toString() {
        String c = this.code != null ? "Code: " + this.code : null;
        String m = this.text != null ? "Message: " + this.getText() : null;
        return Stream.of(c, m).filter(Objects::nonNull).collect(Collectors.joining(" | "));
    }

    @Override
    public int compareTo(@NotNull ValidationMessage o) {
        return Comparator.comparing(ValidationMessage::getCode, Comparator.nullsLast(String::compareToIgnoreCase)).thenComparing(ValidationMessage::getText, Comparator.nullsLast(String::compareToIgnoreCase)).compare(this, o);
    }
}

