/*
 * Decompiled with CFR 0.152.
 */
package de.mlo.dev.validation;

import de.mlo.dev.validation.ValidationMessage;
import java.util.Comparator;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValidationInfo
implements Comparable<ValidationInfo> {
    private static final ValidationInfo VALID = new ValidationInfo(true, ValidationMessage.empty());
    private final boolean valid;
    private final ValidationMessage message;

    public ValidationInfo(boolean valid, ValidationMessage message) {
        this.valid = valid;
        this.message = Objects.requireNonNullElse(message, ValidationMessage.empty());
    }

    @NotNull
    public static ValidationInfo valid() {
        return VALID;
    }

    @NotNull
    public static ValidationInfo valid(@Nullable String text) {
        return new ValidationInfo(true, ValidationMessage.justText(text));
    }

    @NotNull
    public static ValidationInfo valid(@Nullable ValidationMessage message) {
        return new ValidationInfo(true, message);
    }

    @NotNull
    public static Builder buildValid() {
        return Builder.valid();
    }

    @NotNull
    public static ValidationInfo invalid(@Nullable String text) {
        return new ValidationInfo(false, ValidationMessage.justText(text));
    }

    public static ValidationInfo invalidCode(@Nullable String code) {
        return new ValidationInfo(false, ValidationMessage.justCode(code));
    }

    public static ValidationInfo invalidCode(@Nullable String code, String message) {
        return new ValidationInfo(false, ValidationMessage.of(code, message));
    }

    @NotNull
    public static ValidationInfo invalid(@Nullable ValidationMessage message) {
        return new ValidationInfo(false, message);
    }

    @NotNull
    public static ValidationInfo invalid(@NotNull String messageFormat, Object ... args) {
        return new ValidationInfo(false, ValidationMessage.formattedText(messageFormat, args));
    }

    public static Builder buildInvalid() {
        return Builder.invalid();
    }

    public static Builder build(boolean valid) {
        return new Builder(valid);
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isInvalid() {
        return !this.valid;
    }

    @NotNull
    public ValidationMessage getMessage() {
        return this.message;
    }

    @Nullable
    public String getMessageText() {
        return this.message.getText();
    }

    @Nullable
    public String getMessageCode() {
        return this.message.getCode();
    }

    @Override
    public int compareTo(@NotNull ValidationInfo o) {
        return Comparator.comparing(this::compareValid).thenComparing(ValidationInfo::getMessage).compare(this, o);
    }

    private int compareValid(@NotNull ValidationInfo o) {
        return Boolean.compare(this.isValid(), o.isValid());
    }

    @Generated
    public String toString() {
        return "ValidationInfo(valid=" + this.isValid() + ", message=" + this.getMessage() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationInfo)) {
            return false;
        }
        ValidationInfo other = (ValidationInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isValid() != other.isValid()) {
            return false;
        }
        ValidationMessage this$message = this.getMessage();
        ValidationMessage other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ValidationInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isValid() ? 79 : 97);
        ValidationMessage $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public static class Builder {
        private final boolean valid;
        private String code;
        private String message;
        private Object[] parameter;

        private Builder(boolean valid) {
            this.valid = valid;
        }

        private static Builder valid() {
            return new Builder(true);
        }

        private static Builder invalid() {
            return new Builder(false);
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder parameter(Object ... parameter) {
            this.parameter = parameter;
            return this;
        }

        public ValidationInfo build() {
            return new ValidationInfo(this.valid, new ValidationMessage(this.code, this.message, this.parameter));
        }
    }
}

