/*
 * Decompiled with CFR 0.152.
 */
package de.mlo.dev.validation;

import de.mlo.dev.validation.ValidationInfo;
import de.mlo.dev.validation.ValidationInstruction;
import de.mlo.dev.validation.ValidationResult;
import java.util.ArrayList;
import java.util.List;

public class Validator {
    private final List<ValidationInstruction> instructions = new ArrayList<ValidationInstruction>();

    public Validator add(ValidationInstruction instruction) {
        if (instruction != null) {
            this.instructions.add(instruction);
        }
        return this;
    }

    public ValidationResult validateAll() {
        ValidationResult result = new ValidationResult();
        for (ValidationInstruction instruction : this.instructions) {
            ValidationInfo info = instruction.validate();
            result.add(info);
        }
        return result;
    }

    public ValidationResult validateStopOnFirstFail() {
        ValidationResult result = new ValidationResult();
        for (ValidationInstruction instruction : this.instructions) {
            ValidationInfo info = instruction.validate();
            result.add(info);
            if (!result.isInvalid()) continue;
            return result;
        }
        return result;
    }
}

