/*
 * Decompiled with CFR 0.152.
 */
package de.mlo.dev.validation;

import de.mlo.dev.validation.ValidationInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ValidationResult {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final List<ValidationInfo> infos = new ArrayList<ValidationInfo>();
    private boolean valid = true;

    public ValidationResult add(ValidationResult validationResult) {
        return this.add(validationResult.infos);
    }

    public ValidationResult add(ValidationInfo first, ValidationInfo ... more) {
        this.add(first);
        for (ValidationInfo info : more) {
            this.add(info);
        }
        return this;
    }

    public ValidationResult add(Collection<ValidationInfo> validationInfos) {
        for (ValidationInfo info : validationInfos) {
            this.add(info);
        }
        return this;
    }

    public ValidationResult add(ValidationInfo validationInfo) {
        if (validationInfo != null) {
            this.infos.add(validationInfo);
            this.valid = this.valid && validationInfo.isValid();
        }
        return this;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isInvalid() {
        return !this.valid;
    }

    public List<ValidationInfo> getInfos() {
        return new ArrayList<ValidationInfo>(this.infos);
    }

    public String getMessage() {
        return this.getMessage(LINE_SEPARATOR);
    }

    public String getMessage(String delimiter) {
        return this.infos.stream().map(ValidationInfo::getMessage).filter(Objects::nonNull).collect(Collectors.joining(delimiter));
    }

    public List<String> getMessages() {
        return this.infos.stream().map(ValidationInfo::getMessage).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

