/*
 * Decompiled with CFR 0.152.
 */
package de.mlo.dev.validation;

import java.util.Objects;
import java.util.function.Supplier;

public class ValidationInfo {
    private static final Supplier<String> NO_MESSAGE = () -> null;
    private final boolean valid;
    private final Supplier<String> message;

    public ValidationInfo(boolean valid, String message) {
        this(valid, () -> message);
    }

    public ValidationInfo(boolean valid, Supplier<String> message) {
        this.valid = valid;
        this.message = Objects.requireNonNullElse(message, NO_MESSAGE);
    }

    public static ValidationInfo valid() {
        return new ValidationInfo(true, NO_MESSAGE);
    }

    public static ValidationInfo valid(String message) {
        return new ValidationInfo(true, message);
    }

    public static ValidationInfo valid(Supplier<String> message) {
        return new ValidationInfo(true, message);
    }

    public static ValidationInfo invalid(String message) {
        return new ValidationInfo(false, message);
    }

    public static ValidationInfo invalid(Supplier<String> message) {
        return new ValidationInfo(false, message);
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isInvalid() {
        return !this.valid;
    }

    public String getMessage() {
        return this.message.get();
    }
}

