/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.htmlinliner;

import de.mklinger.qetcher.htmlinliner.Cookie;
import de.mklinger.qetcher.htmlinliner.HtmlElementInlinerException;
import de.mklinger.qetcher.htmlinliner.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.WriterOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLoaderImpl
implements ResourceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceLoaderImpl.class);
    private static final Pattern CHARSET_PATTERN = Pattern.compile(";\\s*charset=([^;]+)", 2);
    private final Supplier<Collection<Cookie>> cookieSupplier;

    public ResourceLoaderImpl(Supplier<Collection<Cookie>> cookieSupplier) {
        this.cookieSupplier = cookieSupplier;
    }

    @Override
    public Optional<String> getContents(URI url, URI referrer) {
        LOG.info("Fetching {} for inline contents", (Object)url);
        try {
            URLConnection connection = this.get(url, referrer);
            Charset charset = this.getCharset(connection);
            StringWriter sw = new StringWriter();
            WriterOutputStream wout = new WriterOutputStream((Writer)sw, charset);
            try (InputStream in = connection.getInputStream();){
                IOUtils.copy((InputStream)in, (OutputStream)wout);
            }
            wout.flush();
            String contents = sw.toString();
            return Optional.of(contents);
        }
        catch (Exception e) {
            LOG.info("Error getting contents for inlining: {}", (Object)url);
            LOG.debug("Error getting contents for inlining had exception:", (Throwable)e);
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<String> getExternalInlineImgSrc(URI url, URI referrer) {
        LOG.info("Fetching {} for inline image", (Object)url);
        try {
            URLConnection connection = this.get(url, referrer);
            String contentType = this.getImageContentType(connection);
            try (InputStream in = connection.getInputStream();){
                Optional<String> optional = Optional.of(this.getInlineImgSrc(contentType, in));
                return optional;
            }
        }
        catch (Exception e) {
            LOG.info("Error getting contents for inlining: {}", (Object)url);
            LOG.debug("Error getting contents for inlining had exception:", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public String getInlineImgSrc(String contentType, InputStream in) throws IOException {
        byte[] data = IOUtils.toByteArray((InputStream)in);
        String base64Data = Base64.getEncoder().encodeToString(data);
        StringBuilder sb = new StringBuilder(base64Data.length() + "data:".length() + contentType.length() + ";base64,".length());
        sb.append("data:");
        sb.append(contentType);
        sb.append(";base64,");
        sb.append(base64Data);
        return sb.toString();
    }

    private URLConnection get(URI uri, URI referrer) throws IOException {
        int statusCode;
        URLConnection connection = uri.toURL().openConnection();
        if (this.isSameHost(uri, referrer)) {
            LOG.debug("Using cookies for url {}", (Object)uri);
            this.setCookies(connection, this.cookieSupplier);
        }
        connection.connect();
        if (connection instanceof HttpURLConnection && (statusCode = ((HttpURLConnection)connection).getResponseCode()) != 200) {
            throw new HtmlElementInlinerException("Non 200 status code (" + statusCode + ") for content: " + uri);
        }
        return connection;
    }

    private boolean isSameHost(URI uri1, URI uri2) {
        return uri1.getScheme() != null && uri1.getScheme().equals(uri2.getScheme()) && uri1.getHost() != null && uri1.getHost().equals(uri2.getHost()) && uri1.getPort() == uri2.getPort();
    }

    private void setCookies(URLConnection connection, Supplier<Collection<Cookie>> cookieSupplier) {
        if (cookieSupplier == null) {
            LOG.debug("No cookie supplier available");
            return;
        }
        Collection<Cookie> cookies = cookieSupplier.get();
        if (cookies == null || cookies.isEmpty()) {
            LOG.debug("No cookies");
            return;
        }
        for (Cookie cookie : cookies) {
            connection.addRequestProperty("Cookie", cookie.getName() + "=" + cookie.getValue());
        }
    }

    private Charset getCharset(URLConnection connection) {
        Matcher matcher;
        String contentType = connection.getContentType();
        if (contentType != null && !contentType.isEmpty() && (matcher = CHARSET_PATTERN.matcher(contentType)).find()) {
            String responseCharset = matcher.group(1).trim();
            try {
                Charset charset = Charset.forName(responseCharset);
                LOG.debug("Using response charset: {}", (Object)charset);
                return charset;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return StandardCharsets.UTF_8;
    }

    private String getImageContentType(URLConnection connection) {
        String contentType = connection.getContentType();
        if (contentType == null) {
            throw new HtmlElementInlinerException("No content type available for inline image");
        }
        if (!contentType.toLowerCase(Locale.US).startsWith("image/")) {
            throw new HtmlElementInlinerException("Unsupported content type for inline image: '" + contentType + "'");
        }
        return contentType;
    }

    @Override
    public void close() {
    }
}

