/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.mklinger.micro.uribuilder.UriBuilder;
import de.mklinger.qetcher.client.InputConversionFile;
import de.mklinger.qetcher.client.InputJob;
import de.mklinger.qetcher.client.QetcherClient;
import de.mklinger.qetcher.client.QetcherClientException;
import de.mklinger.qetcher.client.QetcherRemoteException;
import de.mklinger.qetcher.client.common.concurrent.Delay;
import de.mklinger.qetcher.client.impl.lookup.ServiceUriSupplier;
import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.AvailableNode;
import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.Error;
import de.mklinger.qetcher.client.model.v1.Job;
import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.client.model.v1.MediaTypes;
import de.mklinger.qetcher.client.model.v1.builder.ErrorBuilder;
import de.mklinger.qetcher.client.model.v1.jackson.ObjectMapperConfigurer;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQetcherClient
implements QetcherClient {
    private static final ObjectMapper objectMapper = ObjectMapperConfigurer.configure((ObjectMapper)new ObjectMapper());
    private static final Logger LOG = LoggerFactory.getLogger(AbstractQetcherClient.class);
    private final ServiceUriSupplier serviceUriSupplier;

    public AbstractQetcherClient(ServiceUriSupplier serviceUriSupplier) {
        this.serviceUriSupplier = serviceUriSupplier;
    }

    public ServiceUriSupplier getServiceUriSupplier() {
        return this.serviceUriSupplier;
    }

    @Override
    public abstract void close();

    @Override
    public abstract CompletableFuture<ConversionFile> uploadFile(InputConversionFile var1);

    @Override
    public abstract CompletableFuture<ConversionFile> getFile(String var1);

    @Override
    public abstract CompletableFuture<List<ConversionFile>> getFiles();

    @Override
    public abstract CompletableFuture<Void> deleteFile(String var1);

    @Override
    public abstract CompletableFuture<Path> downloadAsFile(String var1, Path var2, OpenOption ... var3);

    @Override
    public abstract CompletableFuture<Job> createJob(InputJob var1);

    @Override
    public abstract CompletableFuture<Job> getJob(String var1);

    @Override
    public abstract CompletableFuture<List<Job>> getJobs();

    @Override
    public abstract CompletableFuture<Void> deleteJob(String var1);

    @Override
    public abstract CompletableFuture<List<AvailableConversion>> getAvailableConversions();

    @Override
    public abstract CompletableFuture<List<AvailableNode>> getAvailableNodes();

    @Override
    public CompletableFuture<ConversionFile> getFile(ConversionFile file) {
        return this.getFile(file.getFileId());
    }

    @Override
    public CompletableFuture<Void> deleteFile(ConversionFile file) {
        return this.deleteFile(file.getFileId());
    }

    @Override
    public CompletableFuture<Path> downloadAsFile(String fileId, Path file) {
        return this.downloadAsFile(fileId, file, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
    }

    @Override
    public CompletableFuture<File> downloadAsFile(String fileId, File file) {
        return this.downloadAsFile(fileId, file.toPath()).thenApply(Path::toFile);
    }

    @Override
    public CompletableFuture<Path> downloadAsTempFile(String fileId) {
        Path file;
        try {
            file = Files.createTempFile(fileId, ".tmp", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this.downloadAsFile(fileId, file);
    }

    @Override
    public CompletableFuture<Path> downloadAsTempFile(String fileId, Path dir) {
        Path file;
        try {
            file = Files.createTempFile(dir, fileId, ".tmp", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this.downloadAsFile(fileId, file);
    }

    @Override
    public CompletableFuture<Job> getJob(Job job) {
        return this.getJob(job.getJobId());
    }

    @Override
    public CompletableFuture<Void> deleteJob(Job job) {
        return this.deleteJob(job.getJobId());
    }

    @Override
    public CompletableFuture<Job> getJobDone(Job job) {
        return this.getJobDone(job.getJobId());
    }

    @Override
    public CompletableFuture<Job> getJobDone(String jobId) {
        CompletableFuture<Job> cf = new CompletableFuture<Job>();
        new JobStatePollerUntilDone(jobId, cf).run();
        return cf;
    }

    protected URI getFileUploadUri() {
        return this.getFilesUri();
    }

    protected String getFileUploadMethod() {
        return "POST";
    }

    protected URI getFileUri(String fileId) {
        return this.getServiceUriBuilder().pathComponent("v1").pathComponent("files").pathComponent(fileId).build();
    }

    protected URI getFileContentsUri(String fileId) {
        return this.getServiceUriBuilder().pathComponent("v1").pathComponent("files").pathComponent(fileId).pathComponent("contents").build();
    }

    protected URI getFilesUri() {
        return this.getServiceUriBuilder().pathComponent("v1").pathComponent("files").build();
    }

    protected URI getCreateJobForExistingFileUri() {
        return this.getJobsUri();
    }

    protected String getCreateJobForExistingFileMethod() {
        return "POST";
    }

    protected URI getCreateJobForNewFileUri() {
        return this.getJobsUri();
    }

    protected String getCreateJobForNewFileMethod() {
        return "POST";
    }

    protected URI getJobUri(String jobId) {
        return this.getServiceUriBuilder().pathComponent("v1").pathComponent("jobs").pathComponent(jobId).build();
    }

    protected URI getJobsUri() {
        return this.getServiceUriBuilder().pathComponent("v1").pathComponent("jobs").build();
    }

    protected URI getConversionsUri() {
        return this.getServiceUriBuilder().pathComponent("v1").pathComponent("conversions").build();
    }

    protected URI getAvailableNodesUri() {
        return this.getServiceUriBuilder().pathComponent("v1").pathComponent("nodes").build();
    }

    private UriBuilder getServiceUriBuilder() {
        return UriBuilder.of((URI)this.getServiceUri());
    }

    private URI getServiceUri() {
        return (URI)this.serviceUriSupplier.get();
    }

    protected <T> T transformResponse(int statusCode, Optional<String> contentType, byte[] responseBody, Class<T> type) {
        this.requireSuccessStatusCode(statusCode, contentType, Optional.of(responseBody));
        return this.getResponseObject(contentType, responseBody, type);
    }

    protected void requireSuccessStatusCode(int statusCode, Optional<String> contentType, Optional<byte[]> responseBody) {
        LOG.debug("Status {}", (Object)statusCode);
        if (!this.isSuccessStatusCode(statusCode)) {
            Error error = this.getErrorObject(statusCode, contentType, responseBody);
            throw new QetcherRemoteException(error, statusCode);
        }
    }

    private Error getErrorObject(int statusCode, Optional<String> contentType, Optional<byte[]> responseBody) {
        if (responseBody.isPresent()) {
            try {
                return this.getResponseObject(contentType, responseBody.get(), Error.class);
            }
            catch (Exception e) {
                LOG.info("Unable to get error response object", (Throwable)e);
            }
        }
        return new ErrorBuilder().status(String.valueOf(statusCode)).message("No remote error information available").build();
    }

    private <T> T getResponseObject(Optional<String> contentType, byte[] responseBody, Class<T> type) {
        if (contentType.isPresent() && !MediaTypes.JSON.isCompatible(MediaType.valueOf((String)contentType.get()))) {
            throw new QetcherClientException("Unsupported content type: " + contentType.get());
        }
        if (type == Void.class) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(responseBody, type);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean isSuccessStatusCode(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    private class JobStatePollerUntilDone
    implements Runnable {
        private final String jobId;
        private final CompletableFuture<Job> cf;
        private final AtomicLong nextDelayMillis;

        public JobStatePollerUntilDone(String jobId, CompletableFuture<Job> cf) {
            this.jobId = jobId;
            this.cf = cf;
            this.nextDelayMillis = new AtomicLong(100L);
        }

        @Override
        public void run() {
            ((CompletableFuture)AbstractQetcherClient.this.getJob(this.jobId).thenAccept(job -> {
                switch (job.getState()) {
                    case INITIALIZING: 
                    case IN_PROGRESS: 
                    case PAUSED: 
                    case WAITING: {
                        long delayMillis = this.nextDelayMillis.getAndUpdate(this::getNextDelay);
                        Delay.delayedExecutor(delayMillis, TimeUnit.MILLISECONDS).execute(this);
                        break;
                    }
                    case CANCELED: 
                    case ERROR: 
                    case SUCCESS: {
                        this.cf.complete((Job)job);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported job state: " + job.getState());
                    }
                }
            })).exceptionally(e -> {
                this.cf.completeExceptionally((Throwable)e);
                return null;
            });
        }

        private long getNextDelay(long currentDelay) {
            if (currentDelay >= 5000L) {
                return 5000L;
            }
            long nextDelay = (long)(1.5 * (double)currentDelay);
            if (nextDelay >= 5000L) {
                return 5000L;
            }
            return nextDelay;
        }
    }
}

