package de.mklinger.qetcher.client;

import java.io.File;
import java.nio.file.Path;

import de.mklinger.commons.httpclient.BodyProviders;
import de.mklinger.qetcher.client.impl.InputConversionFileBuilderImpl;
import de.mklinger.qetcher.client.impl.InputJobBuilderImpl;
import de.mklinger.qetcher.client.impl.QetcherClientBuilderImpl;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class QetcherClientBuilders {
	/** Not to be instantiated. */
	private QetcherClientBuilders() {}

	public static QetcherClient.Builder client() {
		return new QetcherClientBuilderImpl();
	}

	public static InputConversionFile.Builder inputFile() {
		return new InputConversionFileBuilderImpl();
	}

	public static InputConversionFile.Builder inputFileFor(final File inputFile) {
		return inputFileFor(inputFile.toPath());
	}

	public static InputConversionFile.Builder inputFileFor(final Path inputFile) {
		return new InputConversionFileBuilderImpl()
				.filename(inputFile.getFileName().toString())
				.bodyProvider(BodyProviders.fromFile(inputFile));
	}

	public static InputJob.Builder job() {
		return new InputJobBuilderImpl();
	}
}
