/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.impl.retry;

import de.mklinger.micro.annotations.VisibleForTesting;
import de.mklinger.micro.throwables.Throwables;
import de.mklinger.qetcher.client.InputConversionFile;
import de.mklinger.qetcher.client.InputJob;
import de.mklinger.qetcher.client.QetcherRemoteException;
import de.mklinger.qetcher.client.common.concurrent.Delay;
import de.mklinger.qetcher.client.impl.QetcherClientBuilderImpl;
import de.mklinger.qetcher.client.impl.QetcherClientImpl;
import de.mklinger.qetcher.client.impl.lookup.ServiceUriSupplier;
import de.mklinger.qetcher.client.impl.retry.RetryFailedException;
import de.mklinger.qetcher.client.impl.retry.RetryFailedGenericException;
import de.mklinger.qetcher.client.impl.retry.RetryFailedQetcherRemoteException;
import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.AvailableNode;
import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.Job;
import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryingQetcherClientImpl
extends QetcherClientImpl {
    private static final Logger LOG = LoggerFactory.getLogger(RetryingQetcherClientImpl.class);
    private static final int MAX_TRIES = 10;
    private static final int DEFAULT_MAX_WAIT_TIME_MILLIS = 1000;
    private final long maxWaitTimeMillis;

    public RetryingQetcherClientImpl(QetcherClientBuilderImpl builder, ServiceUriSupplier serviceUriSupplier) {
        this(builder, serviceUriSupplier, 1000L);
    }

    @VisibleForTesting
    protected RetryingQetcherClientImpl(QetcherClientBuilderImpl builder, ServiceUriSupplier serviceUriSupplier, long maxWaitTimeMillis) {
        super(builder, serviceUriSupplier);
        this.maxWaitTimeMillis = maxWaitTimeMillis;
    }

    @Override
    public CompletableFuture<ConversionFile> uploadFile(InputConversionFile inputFile) {
        return this.doWithRetry(() -> super.uploadFile(inputFile));
    }

    @Override
    public CompletableFuture<ConversionFile> getFile(String fileId) {
        return this.doWithRetry(() -> super.getFile(fileId));
    }

    @Override
    public CompletableFuture<List<ConversionFile>> getFiles() {
        return this.doWithRetry(() -> super.getFiles());
    }

    @Override
    public CompletableFuture<Void> deleteFile(String fileId) {
        return this.doWithRetry(() -> super.deleteFile(fileId));
    }

    @Override
    public CompletableFuture<Path> downloadAsFile(String fileId, Path file, OpenOption ... openOptions) {
        return this.doWithRetry(() -> super.downloadAsFile(fileId, file, openOptions));
    }

    @Override
    public CompletableFuture<Job> createJob(InputJob inputJob) {
        return this.doWithRetry(() -> super.createJob(inputJob));
    }

    @Override
    public CompletableFuture<Job> getJob(String jobId) {
        return this.doWithRetry(() -> super.getJob(jobId));
    }

    @Override
    public CompletableFuture<List<Job>> getJobs() {
        return this.doWithRetry(() -> super.getJobs());
    }

    @Override
    public CompletableFuture<Void> deleteJob(String jobId) {
        return this.doWithRetry(() -> super.deleteJob(jobId));
    }

    @Override
    public CompletableFuture<List<AvailableConversion>> getAvailableConversions() {
        return this.doWithRetry(() -> super.getAvailableConversions());
    }

    @Override
    public CompletableFuture<List<AvailableNode>> getAvailableNodes() {
        return this.doWithRetry(() -> super.getAvailableNodes());
    }

    @Override
    public CompletableFuture<ConversionFile> getFile(ConversionFile file) {
        return this.doWithRetry(() -> super.getFile(file));
    }

    @Override
    public CompletableFuture<Void> deleteFile(ConversionFile file) {
        return this.doWithRetry(() -> super.deleteFile(file));
    }

    @Override
    public CompletableFuture<Path> downloadAsFile(String fileId, Path file) {
        return this.doWithRetry(() -> super.downloadAsFile(fileId, file));
    }

    @Override
    public CompletableFuture<File> downloadAsFile(String fileId, File file) {
        return this.doWithRetry(() -> super.downloadAsFile(fileId, file));
    }

    @Override
    public CompletableFuture<Path> downloadAsTempFile(String fileId) {
        return this.doWithRetry(() -> super.downloadAsTempFile(fileId));
    }

    @Override
    public CompletableFuture<Path> downloadAsTempFile(String fileId, Path dir) {
        return this.doWithRetry(() -> super.downloadAsTempFile(fileId, dir));
    }

    @Override
    public CompletableFuture<Job> getJob(Job job) {
        return this.doWithRetry(() -> super.getJob(job));
    }

    @Override
    public CompletableFuture<Void> deleteJob(Job job) {
        return this.doWithRetry(() -> super.deleteJob(job));
    }

    @Override
    public CompletableFuture<Job> getJobDone(Job job) {
        return this.doWithRetry(() -> super.getJobDone(job));
    }

    @Override
    public CompletableFuture<Job> getJobDone(String jobId) {
        return this.doWithRetry(() -> super.getJobDone(jobId));
    }

    private <T> CompletableFuture<T> doWithRetry(Supplier<CompletableFuture<T>> action) {
        CompletableFuture cf = new CompletableFuture();
        new Retrier(cf, action, this.maxWaitTimeMillis).run();
        return cf;
    }

    private static class Retrier<T>
    implements Runnable {
        private final Supplier<CompletableFuture<T>> action;
        private final CompletableFuture<T> cf;
        private final AtomicInteger tries;
        private final AtomicReference<Throwable> error;
        private final long maxWaitTimeMillis;

        public Retrier(CompletableFuture<T> cf, Supplier<CompletableFuture<T>> action, long maxWaitTimeMillis) {
            this.cf = cf;
            this.action = action;
            this.tries = new AtomicInteger(0);
            this.error = new AtomicReference();
            this.maxWaitTimeMillis = maxWaitTimeMillis;
        }

        @Override
        public void run() {
            this.tries.incrementAndGet();
            if (this.tries.get() > 1) {
                LOG.info("Try #{}", (Object)this.tries.get());
            }
            ((CompletableFuture)this.action.get().thenAccept(this.cf::complete)).exceptionally(newError -> {
                Throwable e = this.unwrapCompletionException((Throwable)newError);
                if (!this.error.compareAndSet(null, this.newRetryFailedException(e))) {
                    this.error.get().addSuppressed(e);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Completing retrier with error: {}", (Object)this.error.get().toString());
                }
                if (this.tries.get() < 10 && this.isRetryCandidate((Throwable)newError)) {
                    long waitTimeMillis = this.getWaitTimeMillis();
                    LOG.info("Triggering try #{} in {} millis after error: {}", new Object[]{this.tries.get() + 1, waitTimeMillis, newError.toString()});
                    Delay.delayedExecutor(waitTimeMillis, TimeUnit.MILLISECONDS).execute(this);
                } else {
                    this.cf.completeExceptionally(this.error.get());
                }
                return null;
            });
        }

        private RuntimeException newRetryFailedException(Throwable newError) {
            if (newError instanceof QetcherRemoteException) {
                return new RetryFailedQetcherRemoteException((QetcherRemoteException)newError);
            }
            return new RetryFailedGenericException(newError);
        }

        private Throwable unwrapCompletionException(Throwable error) {
            if (error instanceof CompletionException && error.getCause() != null) {
                return error.getCause();
            }
            return error;
        }

        private long getWaitTimeMillis() {
            return Math.min(this.maxWaitTimeMillis, 50L * (long)this.tries.get() + 50L + ThreadLocalRandom.current().nextLong(50L));
        }

        private boolean isRetryCandidate(Throwable error) {
            return !Throwables.firstCause((Throwable)error, RetryFailedException.class).isPresent() && (Throwables.firstCause((Throwable)error, IOException.class).isPresent() || Throwables.firstCause((Throwable)error, QetcherRemoteException.class).map(QetcherRemoteException::getStatusCode).map(statusCode -> statusCode == 404 || statusCode == 417).orElse(false) != false);
        }
    }
}

