package de.mklinger.qetcher.client.model.v1.impl;

import java.util.Objects;
import java.util.Set;

import de.mklinger.micro.mediatype.MediaType;
import de.mklinger.micro.sets.Sets;
import de.mklinger.qetcher.client.model.v1.Conversion;
import de.mklinger.qetcher.client.model.v1.ModelValidationException;
import de.mklinger.qetcher.client.model.v1.builder.ConversionBuilder;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class ConversionImpl implements Conversion {
	private final MediaType from;
	private final MediaType to;
	private final int priority;
	private final Set<String> supportedParameters;

	public ConversionImpl(final ConversionBuilder conversionBuilder) {
		this.from = conversionBuilder.getFrom();
		this.to = conversionBuilder.getTo();
		this.priority = conversionBuilder.getPriority();
		this.supportedParameters = Sets.newImmutableSet(conversionBuilder.getSupportedParameters());

		try {
			validate();
		} catch (final Exception e) {
			throw new ModelValidationException(Conversion.class, e);
		}
	}

	private void validate() {
		Objects.requireNonNull(from);
		Objects.requireNonNull(to);
		Objects.requireNonNull(supportedParameters);
	}

	@Override
	public MediaType getFrom() {
		return from;
	}

	@Override
	public MediaType getTo() {
		return to;
	}

	@Override
	public int getPriority() {
		return priority;
	}

	@Override
	public Set<String> getSupportedParameters() {
		return supportedParameters;
	}

	@Override
	public String toString() {
		final StringBuilder sb = new StringBuilder();
		sb.append("ConversionImpl [from=");
		sb.append(from);
		sb.append(", to=");
		sb.append(to);
		sb.append(", priority=");
		sb.append(priority);
		sb.append(", supportedParameters=");
		sb.append(supportedParameters);
		sb.append("]");
		return sb.toString();
	}

}
