package de.mklinger.qetcher.client.model.v1;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;

import de.mklinger.micro.mediatype.MediaType;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public interface Job {

	String getJobId();

	String getParentJobId();

	String getTenantId();

	String getNodeId();

	String getConverterId();

	/**
	 * Get the job priority. Higher value is higher priority. Jobs with higher
	 * priorities will be processed before jobs with lower priority.
	 */
	int getPriority();

	MediaType getFromMediaType();

	/**
	 * Get input file ids for this job. The list of input file ids is never empty.
	 * Input file ids keep the order in which they where added.
	 */
	List<String> getInputFileIds();

	MediaType getToMediaType();

	List<String> getResultFileIds();

	String getReferrer();

	Duration getCancelTimeout();

	Duration getDeleteTimeout();

	JobState getState();

	Error getError();

	Map<String, String> getProperties();

	Instant getCreated();

	Instant getUpdated();

	Duration getEstimatedRunTime();

}