package de.mklinger.qetcher.client;

import java.time.Duration;

import de.mklinger.micro.mediatype.MediaType;
import de.mklinger.qetcher.client.model.v1.ConversionFile;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public interface InputJob {
	String getConversionFileId();
	InputConversionFile getInputConversionFile();
	MediaType getFromMediaType();
	MediaType getToMediaType();
	Duration getDeleteTimeout();
	Duration getCancelTimeout();
	String getReferrer();

	public interface Builder {
		Builder fromFile(String conversionFileId);
		Builder fromFile(ConversionFile conversionFile);
		Builder fromFile(InputConversionFile inputConversionFile);
		Builder fromMediaType(MediaType mediaType);
		Builder toMediaType(MediaType mediaType);
		Builder deleteTimeout(Duration deleteTimeout);
		Builder cancelTimeout(Duration cancelTimeout);
		Builder referrer(String referrer);
		InputJob build();
	}
}
