package de.mklinger.qetcher.client.impl;

import de.mklinger.qetcher.client.InputConversionFile;
import de.mklinger.qetcher.client.InputJob;
import de.mklinger.qetcher.client.QetcherClient;
import de.mklinger.qetcher.client.impl.lookup.NodeLookupQetcherClientImpl;
import de.mklinger.qetcher.client.impl.lookup.StaticServiceUriSupplier;
import de.mklinger.qetcher.client.impl.retry.RetryingQetcherClientImpl;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class InstanceFactory {
	public static QetcherClient newInstance(final QetcherClientBuilderImpl builder) {
		if (builder.isServiceLookupDisabled()) {
			return new RetryingQetcherClientImpl(builder, new StaticServiceUriSupplier(builder.getServiceUris()));
		} else {
			return new NodeLookupQetcherClientImpl(builder);
		}
	}

	public static InputConversionFile newInstance(final InputConversionFileBuilderImpl builder) {
		return new InputConversionFileImpl(builder);
	}

	public static InputJob newInstance(final InputJobBuilderImpl builder) {
		return new InputJobImpl(builder);
	}
}
