/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.jetty.http2.generator;

import de.mklinger.qetcher.client.jetty.http2.frames.DataFrame;
import de.mklinger.qetcher.client.jetty.http2.frames.Frame;
import de.mklinger.qetcher.client.jetty.http2.frames.FrameType;
import de.mklinger.qetcher.client.jetty.http2.generator.DataGenerator;
import de.mklinger.qetcher.client.jetty.http2.generator.FrameGenerator;
import de.mklinger.qetcher.client.jetty.http2.generator.GoAwayGenerator;
import de.mklinger.qetcher.client.jetty.http2.generator.HeaderGenerator;
import de.mklinger.qetcher.client.jetty.http2.generator.HeadersGenerator;
import de.mklinger.qetcher.client.jetty.http2.generator.NoOpGenerator;
import de.mklinger.qetcher.client.jetty.http2.generator.PingGenerator;
import de.mklinger.qetcher.client.jetty.http2.generator.PrefaceGenerator;
import de.mklinger.qetcher.client.jetty.http2.generator.PriorityGenerator;
import de.mklinger.qetcher.client.jetty.http2.generator.PushPromiseGenerator;
import de.mklinger.qetcher.client.jetty.http2.generator.ResetGenerator;
import de.mklinger.qetcher.client.jetty.http2.generator.SettingsGenerator;
import de.mklinger.qetcher.client.jetty.http2.generator.WindowUpdateGenerator;
import de.mklinger.qetcher.client.jetty.http2.hpack.HpackEncoder;
import de.mklinger.qetcher.client.jetty.http2.hpack.HpackException;
import de.mklinger.qetcher.client.jetty.io.ByteBufferPool;

public class Generator {
    private final ByteBufferPool byteBufferPool;
    private final HeaderGenerator headerGenerator;
    private final HpackEncoder hpackEncoder;
    private final FrameGenerator[] generators;
    private final DataGenerator dataGenerator;

    public Generator(ByteBufferPool byteBufferPool) {
        this(byteBufferPool, 4096, 0);
    }

    public Generator(ByteBufferPool byteBufferPool, int maxDynamicTableSize, int maxHeaderBlockFragment) {
        this.byteBufferPool = byteBufferPool;
        this.headerGenerator = new HeaderGenerator();
        this.hpackEncoder = new HpackEncoder(maxDynamicTableSize);
        this.generators = new FrameGenerator[FrameType.values().length];
        this.generators[FrameType.HEADERS.getType()] = new HeadersGenerator(this.headerGenerator, this.hpackEncoder, maxHeaderBlockFragment);
        this.generators[FrameType.PRIORITY.getType()] = new PriorityGenerator(this.headerGenerator);
        this.generators[FrameType.RST_STREAM.getType()] = new ResetGenerator(this.headerGenerator);
        this.generators[FrameType.SETTINGS.getType()] = new SettingsGenerator(this.headerGenerator);
        this.generators[FrameType.PUSH_PROMISE.getType()] = new PushPromiseGenerator(this.headerGenerator, this.hpackEncoder);
        this.generators[FrameType.PING.getType()] = new PingGenerator(this.headerGenerator);
        this.generators[FrameType.GO_AWAY.getType()] = new GoAwayGenerator(this.headerGenerator);
        this.generators[FrameType.WINDOW_UPDATE.getType()] = new WindowUpdateGenerator(this.headerGenerator);
        this.generators[FrameType.CONTINUATION.getType()] = null;
        this.generators[FrameType.PREFACE.getType()] = new PrefaceGenerator();
        this.generators[FrameType.DISCONNECT.getType()] = new NoOpGenerator();
        this.dataGenerator = new DataGenerator(this.headerGenerator);
    }

    public ByteBufferPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    public void setValidateHpackEncoding(boolean validateEncoding) {
        this.hpackEncoder.setValidateEncoding(validateEncoding);
    }

    public void setHeaderTableSize(int headerTableSize) {
        this.hpackEncoder.setRemoteMaxDynamicTableSize(headerTableSize);
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.headerGenerator.setMaxFrameSize(maxFrameSize);
    }

    public int control(ByteBufferPool.Lease lease, Frame frame) throws HpackException {
        return this.generators[frame.getType().getType()].generate(lease, frame);
    }

    public int data(ByteBufferPool.Lease lease, DataFrame frame, int maxLength) {
        return this.dataGenerator.generate(lease, frame, maxLength);
    }

    public void setMaxHeaderListSize(int value) {
        this.hpackEncoder.setMaxHeaderListSize(value);
    }
}

