/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.jetty.client.http;

import de.mklinger.qetcher.client.jetty.client.AbstractConnectorHttpClientTransport;
import de.mklinger.qetcher.client.jetty.client.DuplexConnectionPool;
import de.mklinger.qetcher.client.jetty.client.HttpDestination;
import de.mklinger.qetcher.client.jetty.client.Origin;
import de.mklinger.qetcher.client.jetty.client.api.Destination;
import de.mklinger.qetcher.client.jetty.client.http.HttpConnectionOverHTTP;
import de.mklinger.qetcher.client.jetty.client.http.HttpDestinationOverHTTP;
import de.mklinger.qetcher.client.jetty.io.Connection;
import de.mklinger.qetcher.client.jetty.io.EndPoint;
import de.mklinger.qetcher.client.jetty.util.Callback;
import de.mklinger.qetcher.client.jetty.util.ProcessorUtils;
import de.mklinger.qetcher.client.jetty.util.Promise;
import de.mklinger.qetcher.client.jetty.util.annotation.ManagedAttribute;
import de.mklinger.qetcher.client.jetty.util.annotation.ManagedObject;
import java.io.IOException;
import java.util.Map;

@ManagedObject(value="The HTTP/1.1 client transport")
public class HttpClientTransportOverHTTP
extends AbstractConnectorHttpClientTransport {
    private int headerCacheSize = 1024;

    public HttpClientTransportOverHTTP() {
        this(Math.max(1, ProcessorUtils.availableProcessors() / 2));
    }

    public HttpClientTransportOverHTTP(int selectors) {
        super(selectors);
        this.setConnectionPoolFactory(destination -> new DuplexConnectionPool((Destination)destination, this.getHttpClient().getMaxConnectionsPerDestination(), (Callback)destination));
    }

    @Override
    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP(this.getHttpClient(), origin);
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("http.destination");
        Promise promise = (Promise)context.get("http.connection.promise");
        HttpConnectionOverHTTP connection = this.newHttpConnection(endPoint, destination, promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", connection);
        }
        return this.customize(connection, context);
    }

    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination destination, Promise<de.mklinger.qetcher.client.jetty.client.api.Connection> promise) {
        return new HttpConnectionOverHTTP(endPoint, destination, promise);
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for an HTTP header field cache")
    public int getHeaderCacheSize() {
        return this.headerCacheSize;
    }

    public void setHeaderCacheSize(int headerCacheSize) {
        this.headerCacheSize = headerCacheSize;
    }
}

