/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.httpclient.internal.jetty;

import de.mklinger.qetcher.client.httpclient.HttpClient;
import de.mklinger.qetcher.client.httpclient.HttpRequest;
import de.mklinger.qetcher.client.httpclient.HttpResponse;
import de.mklinger.qetcher.client.httpclient.internal.NoBodyProvider;
import de.mklinger.qetcher.client.httpclient.internal.jetty.BodyResult;
import de.mklinger.qetcher.client.httpclient.internal.jetty.FullCompleteListener;
import de.mklinger.qetcher.client.httpclient.internal.jetty.HeadersTransformation;
import de.mklinger.qetcher.client.httpclient.internal.jetty.JettyHttpRequest;
import de.mklinger.qetcher.client.httpclient.internal.jetty.JettyHttpResponse;
import de.mklinger.qetcher.client.httpclient.internal.jetty.TimeoutResponseListener;
import de.mklinger.qetcher.client.jetty.client.api.ContentProvider;
import de.mklinger.qetcher.client.jetty.client.api.Request;
import de.mklinger.qetcher.client.jetty.client.api.Response;
import de.mklinger.qetcher.client.jetty.http2.HTTP2Session;
import de.mklinger.qetcher.client.jetty.util.component.Container;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyHttpClient
implements HttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(JettyHttpClient.class);
    private final de.mklinger.qetcher.client.jetty.client.HttpClient jettyClient;
    private volatile boolean closed = false;
    private static final AtomicLong openSessions = new AtomicLong();

    public JettyHttpClient(de.mklinger.qetcher.client.jetty.client.HttpClient jettyClient) {
        this.jettyClient = jettyClient;
        this.jettyClient.addEventListener(new SessionCountListener());
    }

    private de.mklinger.qetcher.client.jetty.client.HttpClient getJettyClient() {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        return this.jettyClient;
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) {
        try {
            Request jettyRequest = this.getJettyClient().newRequest(request.uri()).method(request.method());
            this.applyTimeout(request, jettyRequest);
            this.applyHeaders(request, jettyRequest);
            this.applyBody(request, jettyRequest);
            ForkJoinPool completionExecutor = ForkJoinPool.commonPool();
            FullCompleteListener<T> fullCompleteListener = new FullCompleteListener<T>(completionExecutor, responseBodyHandler);
            Response.CompleteListener possibleTimeoutCompleteListener = this.applyTimeout(request, jettyRequest, fullCompleteListener);
            LOG.debug("Sending jetty request");
            jettyRequest.send(possibleTimeoutCompleteListener);
            return fullCompleteListener.getResult().thenApply(this::toHttpResponse);
        }
        catch (Throwable e) {
            CompletableFuture<HttpResponse<T>> errorResult = new CompletableFuture<HttpResponse<T>>();
            errorResult.completeExceptionally(e);
            return errorResult;
        }
    }

    private void applyTimeout(HttpRequest request, Request jettyRequest) {
        Optional<Duration> timeout = request.timeout();
        if (!timeout.isPresent()) {
            return;
        }
        try {
            jettyRequest.timeout(timeout.get().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (ArithmeticException ex) {
            jettyRequest.timeout(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
    }

    private <T> Response.CompleteListener applyTimeout(HttpRequest request, Request jettyRequest, FullCompleteListener<T> fullCompleteListener) {
        if (request.timeout().isPresent()) {
            return new TimeoutResponseListener(fullCompleteListener, jettyRequest, request.timeout().get().toMillis(), TimeUnit.MILLISECONDS, this.getJettyClient().getScheduler());
        }
        return fullCompleteListener;
    }

    private void applyHeaders(HttpRequest request, Request jettyRequest) {
        request.headers().map().forEach((name, values) -> values.forEach(value -> jettyRequest.header((String)name, (String)value)));
    }

    private void applyBody(HttpRequest request, Request jettyRequest) {
        Optional<HttpRequest.BodyProvider> optionalBodyProvider = request.bodyProvider();
        if (!optionalBodyProvider.isPresent()) {
            return;
        }
        HttpRequest.BodyProvider bodyProvider = optionalBodyProvider.get();
        if (!(bodyProvider instanceof NoBodyProvider)) {
            jettyRequest.content((ContentProvider)((Object)bodyProvider));
        }
    }

    private <T> HttpResponse<T> toHttpResponse(BodyResult<T> result) {
        LOG.debug("Building final HttpResponse");
        return new JettyHttpResponse<T>(result.getResult().getResponse().getStatus(), new JettyHttpRequest(result.getResult().getRequest()), HeadersTransformation.toHttpHeaders(result.getResult().getResponse().getHeaders()), result.getBody());
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            this.jettyClient.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private final class SessionCountListener
    implements Container.InheritedListener {
        private SessionCountListener() {
        }

        @Override
        public void beanAdded(Container parent, Object child) {
            if (child instanceof HTTP2Session) {
                HTTP2Session session = (HTTP2Session)child;
                LOG.debug("Opened HTTP/2 session: {}", (Object)session.getEndPoint().getRemoteAddress());
                openSessions.incrementAndGet();
            }
        }

        @Override
        public void beanRemoved(Container parent, Object child) {
            if (child instanceof HTTP2Session) {
                HTTP2Session session = (HTTP2Session)child;
                LOG.debug("Closed HTTP/2 session: {}", (Object)session.getEndPoint().getRemoteAddress());
                openSessions.decrementAndGet();
            }
        }
    }
}

