/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.httpclient.internal;

import de.mklinger.qetcher.client.httpclient.HttpHeaders;
import de.mklinger.qetcher.client.httpclient.HttpRequest;
import de.mklinger.qetcher.client.httpclient.internal.HttpHeadersImpl;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class HttpRequestBuilderImpl
implements HttpRequest.Builder {
    private URI uri;
    private String method = "GET";
    private HttpHeadersImpl headers;
    public HttpRequest.BodyProvider bodyProvider;
    private Duration timeout;

    public HttpRequestBuilderImpl() {
    }

    public HttpRequestBuilderImpl(URI uri) {
        this.uri = Objects.requireNonNull(uri);
    }

    @Override
    public HttpRequest.Builder uri(URI uri) {
        this.uri = Objects.requireNonNull(uri);
        return this;
    }

    @Override
    public HttpRequest.Builder GET() {
        this.method = "GET";
        return this;
    }

    @Override
    public HttpRequest.Builder POST(HttpRequest.BodyProvider bodyProvider) {
        return this.method("POST", bodyProvider);
    }

    @Override
    public HttpRequest.Builder PUT(HttpRequest.BodyProvider bodyProvider) {
        return this.method("PUT", bodyProvider);
    }

    @Override
    public HttpRequest.Builder DELETE(HttpRequest.BodyProvider bodyProvider) {
        return this.method("DELETE", bodyProvider);
    }

    @Override
    public HttpRequest.Builder method(String method, HttpRequest.BodyProvider bodyProvider) {
        this.method = method;
        this.bodyProvider = Objects.requireNonNull(bodyProvider);
        return this;
    }

    @Override
    public HttpRequest.Builder header(String name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        if (this.headers == null) {
            this.headers = new HttpHeadersImpl();
        }
        this.headers.addHeader(name, value);
        return this;
    }

    @Override
    public HttpRequest.Builder headers(String ... headers) {
        Objects.requireNonNull(headers);
        if (headers.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < headers.length; i += 2) {
            String name = headers[i];
            String value = headers[i + 1];
            this.header(name, value);
        }
        return this;
    }

    @Override
    public HttpRequest.Builder setHeader(String name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        if (this.headers == null) {
            this.headers = new HttpHeadersImpl();
        }
        this.headers.setHeader(name, value);
        return this.header(name, value);
    }

    @Override
    public HttpRequest.Builder timeout(Duration duration) {
        Objects.requireNonNull(duration);
        this.timeout = duration;
        return this;
    }

    @Override
    public HttpRequest build() {
        return new HttpRequestImpl(this);
    }

    private static class HttpRequestImpl
    implements HttpRequest {
        private final URI uri;
        private final String method;
        private final HttpHeaders headers;
        private final Optional<HttpRequest.BodyProvider> bodyProvider;
        private final Optional<Duration> timeout;

        public HttpRequestImpl(HttpRequestBuilderImpl builder) {
            this.uri = Objects.requireNonNull(builder.uri);
            this.method = Objects.requireNonNull(builder.method);
            this.headers = builder.headers == null ? new HttpHeadersImpl() : HttpHeadersImpl.deepCopy(builder.headers);
            this.bodyProvider = Optional.ofNullable(builder.bodyProvider);
            this.timeout = Optional.ofNullable(builder.timeout);
        }

        @Override
        public URI uri() {
            return this.uri;
        }

        @Override
        public String method() {
            return this.method;
        }

        @Override
        public HttpHeaders headers() {
            return this.headers;
        }

        @Override
        public Optional<HttpRequest.BodyProvider> bodyProvider() {
            return this.bodyProvider;
        }

        @Override
        public Optional<Duration> timeout() {
            return this.timeout;
        }
    }
}

