/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.httpclient;

import de.mklinger.qetcher.client.httpclient.HttpRequest;
import de.mklinger.qetcher.client.httpclient.internal.ByteArrayBodyProvider;
import de.mklinger.qetcher.client.httpclient.internal.ByteBufferBodyProvider;
import de.mklinger.qetcher.client.httpclient.internal.FileBodyProvider;
import de.mklinger.qetcher.client.httpclient.internal.InputStreamBodyProvider;
import de.mklinger.qetcher.client.httpclient.internal.NoBodyProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;

public class BodyProviders {
    private BodyProviders() {
    }

    public static HttpRequest.BodyProvider noBody() {
        return NoBodyProvider.getInstance();
    }

    public static HttpRequest.BodyProvider fromByteArray(byte[] b) {
        return new ByteArrayBodyProvider(new byte[][]{b});
    }

    public static HttpRequest.BodyProvider fromByteArray(String contentType, byte[] b) {
        return new ByteArrayBodyProvider(contentType, (byte[][])new byte[][]{b});
    }

    public static HttpRequest.BodyProvider fromByteBuffer(ByteBuffer byteBuffer) {
        return new ByteBufferBodyProvider(byteBuffer);
    }

    public static HttpRequest.BodyProvider fromByteBuffer(String contentType, ByteBuffer byteBuffer) {
        return new ByteBufferBodyProvider(contentType, byteBuffer);
    }

    public static HttpRequest.BodyProvider fromFile(Path file) {
        try {
            return new FileBodyProvider(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static HttpRequest.BodyProvider fromFile(String contentType, Path file) {
        try {
            return new FileBodyProvider(contentType, file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static HttpRequest.BodyProvider fromInputStream(InputStream inputStream) {
        return new InputStreamBodyProvider(inputStream);
    }

    public static HttpRequest.BodyProvider fromInputStream(String contentType, InputStream inputStream) {
        return new InputStreamBodyProvider(contentType, inputStream);
    }
}

