/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.maps;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class Maps {
    private static final int MIN_INITIAL_CAPACITY = 4;

    private Maps() {
    }

    public static <K, V> HashMap<K, V> newHashMap(int expectedSize) {
        return new HashMap(Math.max((int)((float)expectedSize / 0.75f) + 1, 4));
    }

    public static <K, V> Map<K, V> newImmutableMap(Map<K, V> original) {
        if (original == null || original.isEmpty()) {
            return Collections.emptyMap();
        }
        if (original.size() == 1) {
            Map.Entry<K, V> entry = original.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(new HashMap<K, V>(original));
    }

    public static <K, V> HashMap<K, V> newHashMap(K key1, V value1, Object ... others) {
        if (others != null && others.length > 0) {
            if (others.length % 2 != 0) {
                throw new IllegalArgumentException();
            }
            HashMap<Object, Object> m = Maps.newHashMap(others.length / 2 + 1);
            m.put(key1, value1);
            for (int i = 0; i < others.length; i += 2) {
                m.put(others[i], others[i + 1]);
            }
            return m;
        }
        HashMap<K, V> m = Maps.newHashMap(1);
        m.put(key1, value1);
        return m;
    }

    public static <K, V> HashMap<K, V> extend(Map<K, V> original, K key1, V value1, Object ... others) {
        Objects.requireNonNull(original);
        HashMap<Object, Object> m = Maps.newHashMap(original.size() + others.length / 2 + 1);
        m.putAll(original);
        m.put(key1, value1);
        if (others != null && others.length > 0) {
            if (others.length % 2 != 0) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < others.length; i += 2) {
                m.put(others[i], others[i + 1]);
            }
        }
        return m;
    }

    public static <K, V> TreeMap<K, V> newTreeMap(K key1, V value1, Object ... others) {
        TreeMap<Object, Object> m = new TreeMap<Object, Object>();
        m.put(key1, value1);
        if (others != null && others.length > 0) {
            if (others.length % 2 != 0) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < others.length; i += 2) {
                m.put(others[i], others[i + 1]);
            }
        }
        return m;
    }
}

