/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.jackson.datatype.jsr310.ser.key;

import de.mklinger.qetcher.client.jackson.core.JsonGenerator;
import de.mklinger.qetcher.client.jackson.core.JsonProcessingException;
import de.mklinger.qetcher.client.jackson.databind.JsonSerializer;
import de.mklinger.qetcher.client.jackson.databind.SerializationFeature;
import de.mklinger.qetcher.client.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class ZonedDateTimeKeySerializer
extends JsonSerializer<ZonedDateTime> {
    public static final ZonedDateTimeKeySerializer INSTANCE = new ZonedDateTimeKeySerializer();

    private ZonedDateTimeKeySerializer() {
    }

    @Override
    public void serialize(ZonedDateTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        if (serializers.isEnabled(SerializationFeature.WRITE_DATES_WITH_ZONE_ID)) {
            gen.writeFieldName(DateTimeFormatter.ISO_ZONED_DATE_TIME.format(value));
        } else {
            gen.writeFieldName(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(value));
        }
    }
}

