/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client;

import de.mklinger.qetcher.client.QetcherClientException;
import de.mklinger.qetcher.client.model.v1.Error;

public class QetcherRemoteException
extends QetcherClientException {
    private static final long serialVersionUID = 1L;
    private final Error error;
    private final int statusCode;

    public QetcherRemoteException(Error error, int statusCode) {
        super(QetcherRemoteException.newMessage(error, statusCode));
        this.error = error;
        this.statusCode = statusCode;
    }

    private static String newMessage(Error error, int statusCode) {
        String remoteErrorMessage = QetcherRemoteException.toMessage(error);
        if (remoteErrorMessage != null) {
            return "Status code: " + statusCode + " Remote error: " + remoteErrorMessage;
        }
        return "Status code: " + statusCode;
    }

    private static String toMessage(Error errorResponse) {
        String status = errorResponse.getStatus();
        String message = errorResponse.getMessage();
        String errorId = errorResponse.getErrorId();
        if (status == null && message == null && errorId == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(64);
        QetcherRemoteException.appendIfAvailable(sb, "Status", status);
        QetcherRemoteException.appendIfAvailable(sb, "Error Id", errorId);
        if (!"Error".equals(message)) {
            QetcherRemoteException.appendIfAvailable(sb, "Message", message);
        }
        return sb.toString();
    }

    private static void appendIfAvailable(StringBuilder sb, String prefix, String value) {
        if (value != null && !value.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(" - ");
            }
            sb.append(prefix);
            sb.append(": ");
            sb.append(value);
        }
    }

    public Error getError() {
        return this.error;
    }

    public int getStatusCode() {
        return this.statusCode;
    }
}

