package de.mklinger.qetcher.client.model.v1.impl;

import java.util.List;

import de.mklinger.qetcher.client.common.Lists;
import de.mklinger.qetcher.client.model.v1.Job;
import de.mklinger.qetcher.client.model.v1.Jobs;
import de.mklinger.qetcher.client.model.v1.builder.JobsBuilder;

/**
 * Created by Marius Heinzmann on 5/8/17.
 *
 * @author Marius Heinzmann - mheinzmann[at]mklinger[dot]de
 */
public class JobsImpl implements Jobs {
	private final List<Job> jobs;

	public JobsImpl(final JobsBuilder builder) {
		this.jobs = Lists.newImmutableList(builder.getJobs());
	}

	public List<Job> getJobs() {
		return jobs;
	}
}
