package de.mklinger.qetcher.client.model.v1;

import java.time.Duration;
import java.time.Instant;
import java.util.List;

import de.mklinger.qetcher.client.common.MediaType;
import de.mklinger.qetcher.client.common.SizeValue;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public interface ConversionFile {
	String getFileId();

	boolean isServiceManaged();

	String getTenantId();

	String getName();

	SizeValue getSize();

	MediaType getMediaType();

	/**
	 * List of node ids, where this file is physically available.
	 */
	List<String> getNodeIds();

	Instant getCreated();

	Instant getUpdated();

	Duration getDeleteTimeout();
}