/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.jetty.client;

import de.mklinger.qetcher.client.jetty.client.HttpExchange;
import de.mklinger.qetcher.client.jetty.client.api.Response;
import de.mklinger.qetcher.client.jetty.util.AttributesMap;
import de.mklinger.qetcher.client.jetty.util.log.Log;
import de.mklinger.qetcher.client.jetty.util.log.Logger;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;

public class HttpConversation
extends AttributesMap {
    private static final Logger LOG = Log.getLogger(HttpConversation.class);
    private final Deque<HttpExchange> exchanges = new ConcurrentLinkedDeque<HttpExchange>();
    private volatile List<Response.ResponseListener> listeners;

    public Deque<HttpExchange> getExchanges() {
        return this.exchanges;
    }

    public List<Response.ResponseListener> getResponseListeners() {
        return this.listeners;
    }

    public void updateResponseListeners(Response.ResponseListener overrideListener) {
        HttpExchange lastExchange;
        ArrayList<Response.ResponseListener> listeners = new ArrayList<Response.ResponseListener>();
        HttpExchange firstExchange = this.exchanges.peekFirst();
        if (firstExchange == (lastExchange = this.exchanges.peekLast())) {
            if (overrideListener != null) {
                listeners.add(overrideListener);
            } else {
                listeners.addAll(firstExchange.getResponseListeners());
            }
        } else {
            listeners.addAll(lastExchange.getResponseListeners());
            if (overrideListener != null) {
                listeners.add(overrideListener);
            } else {
                listeners.addAll(firstExchange.getResponseListeners());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exchanges in conversation {}, override={}, listeners={}", this.exchanges.size(), overrideListener, listeners);
        }
        this.listeners = listeners;
    }

    public boolean abort(Throwable cause) {
        HttpExchange exchange = this.exchanges.peekLast();
        return exchange != null && exchange.abort(cause);
    }

    @Override
    public String toString() {
        return String.format("%s[%x]", HttpConversation.class.getSimpleName(), this.hashCode());
    }
}

