/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.jackson.databind.ser.impl;

import de.mklinger.qetcher.client.jackson.core.JsonGenerator;
import de.mklinger.qetcher.client.jackson.core.JsonToken;
import de.mklinger.qetcher.client.jackson.core.type.WritableTypeId;
import de.mklinger.qetcher.client.jackson.databind.BeanProperty;
import de.mklinger.qetcher.client.jackson.databind.JsonMappingException;
import de.mklinger.qetcher.client.jackson.databind.JsonNode;
import de.mklinger.qetcher.client.jackson.databind.JsonSerializer;
import de.mklinger.qetcher.client.jackson.databind.SerializationFeature;
import de.mklinger.qetcher.client.jackson.databind.SerializerProvider;
import de.mklinger.qetcher.client.jackson.databind.annotation.JacksonStdImpl;
import de.mklinger.qetcher.client.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import de.mklinger.qetcher.client.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import de.mklinger.qetcher.client.jackson.databind.jsontype.TypeSerializer;
import de.mklinger.qetcher.client.jackson.databind.ser.std.StaticListSerializerBase;
import java.io.IOException;
import java.util.List;

@JacksonStdImpl
public final class IndexedStringListSerializer
extends StaticListSerializerBase<List<String>> {
    private static final long serialVersionUID = 1L;
    public static final IndexedStringListSerializer instance = new IndexedStringListSerializer();

    protected IndexedStringListSerializer() {
        super(List.class);
    }

    public IndexedStringListSerializer(IndexedStringListSerializer src, Boolean unwrapSingle) {
        super(src, unwrapSingle);
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
        return new IndexedStringListSerializer(this, unwrapSingle);
    }

    @Override
    protected JsonNode contentSchema() {
        return this.createSchemaNode("string", true);
    }

    @Override
    protected void acceptContentVisitor(JsonArrayFormatVisitor visitor) throws JsonMappingException {
        visitor.itemsFormat(JsonFormatTypes.STRING);
    }

    @Override
    public void serialize(List<String> value, JsonGenerator g, SerializerProvider provider) throws IOException {
        int len = value.size();
        if (len == 1 && (this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(value, g, provider, 1);
            return;
        }
        g.writeStartArray(value, len);
        this.serializeContents(value, g, provider, len);
        g.writeEndArray();
    }

    @Override
    public void serializeWithType(List<String> value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.START_ARRAY));
        g.setCurrentValue(value);
        this.serializeContents(value, g, provider, value.size());
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    private final void serializeContents(List<String> value, JsonGenerator g, SerializerProvider provider, int len) throws IOException {
        int i;
        try {
            for (i = 0; i < len; ++i) {
                String str = value.get(i);
                if (str == null) {
                    provider.defaultSerializeNull(g);
                    continue;
                }
                g.writeString(str);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(provider, (Throwable)e, value, i);
        }
    }
}

