/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.impl.retry;

import de.mklinger.qetcher.client.QetcherRemoteException;
import de.mklinger.qetcher.client.common.concurrent.Delay;
import de.mklinger.qetcher.client.impl.retry.RetryFailedGenericException;
import de.mklinger.qetcher.client.impl.retry.RetryFailedQetcherRemoteException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retrier<T>
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Retrier.class);
    private final String id = this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this));
    private final Supplier<CompletableFuture<T>> action;
    private final CompletableFuture<T> cf;
    private final AtomicInteger tries;
    private final AtomicReference<Throwable> error;
    private final Predicate<Throwable> isRetryCandidate;
    private final int maxTries;
    private final long maxWaitTimeMillis;

    public Retrier(CompletableFuture<T> cf, Supplier<CompletableFuture<T>> action, Predicate<Throwable> isRetryCandidate, int maxTries, long maxWaitTimeMillis) {
        this.cf = cf;
        this.action = action;
        this.tries = new AtomicInteger(0);
        this.error = new AtomicReference();
        this.isRetryCandidate = isRetryCandidate;
        this.maxTries = maxTries;
        this.maxWaitTimeMillis = maxWaitTimeMillis;
    }

    @Override
    public void run() {
        this.tries.incrementAndGet();
        if (this.tries.get() > 1 && LOG.isInfoEnabled()) {
            LOG.info("{}: Starting try #{}", (Object)this.id, (Object)this.tries.get());
        }
        ((CompletableFuture)this.action.get().thenAccept(this::complete)).exceptionally(this::handleException);
    }

    private void complete(T result) {
        if (this.tries.get() > 1 && LOG.isInfoEnabled()) {
            LOG.info("{}: Completed successfully after try #{}", (Object)this.id, (Object)this.tries.get());
        }
        this.cf.complete(result);
    }

    private Void handleException(Throwable newError) {
        Throwable e = this.unwrapCompletionException(newError);
        if (!this.error.compareAndSet(null, this.newRetryFailedException(e))) {
            this.error.get().addSuppressed(e);
        }
        if (this.tries.get() < this.maxTries && this.isRetryCandidate.test(newError)) {
            this.triggerNextTry(newError);
        } else {
            this.completeExceptionally();
        }
        return null;
    }

    private void triggerNextTry(Throwable newError) {
        long waitTimeMillis = this.getWaitTimeMillis();
        if (LOG.isInfoEnabled()) {
            LOG.info("{}: Triggering try #{} in {} millis after exception: {}", new Object[]{this.id, this.tries.get() + 1, waitTimeMillis, this.unwrapCompletionException(newError).toString()});
        }
        Delay.delayedExecutor(waitTimeMillis, TimeUnit.MILLISECONDS).execute(this);
    }

    private long getWaitTimeMillis() {
        return Math.min(this.maxWaitTimeMillis, 50L * (long)this.tries.get() + 50L + ThreadLocalRandom.current().nextLong(50L));
    }

    private void completeExceptionally() {
        if (this.tries.get() > 1) {
            LOG.warn("{}: Completing exceptionally after {} tries", new Object[]{this.id, this.tries.get(), this.error.get()});
        } else {
            LOG.warn("{}: Completing exceptionally after first try (no retries)", (Object)this.id, (Object)this.error.get());
        }
        this.cf.completeExceptionally(this.error.get());
    }

    private RuntimeException newRetryFailedException(Throwable newError) {
        if (newError instanceof QetcherRemoteException) {
            return new RetryFailedQetcherRemoteException((QetcherRemoteException)newError);
        }
        return new RetryFailedGenericException(newError);
    }

    private Throwable unwrapCompletionException(Throwable error) {
        if (error instanceof CompletionException && error.getCause() != null) {
            return error.getCause();
        }
        return error;
    }
}

