/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.httpclient.internal;

import de.mklinger.qetcher.client.httpclient.HttpClient;
import de.mklinger.qetcher.client.httpclient.internal.ThreadContextClassLoaderQueuedThreadPool;
import de.mklinger.qetcher.client.httpclient.internal.hostnameverifier.DefaultHostnameVerifier;
import de.mklinger.qetcher.client.httpclient.internal.jetty.JettyHttpClient;
import de.mklinger.qetcher.client.jetty.http2.client.HTTP2Client;
import de.mklinger.qetcher.client.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import de.mklinger.qetcher.client.jetty.util.ssl.SslContextFactory;
import java.security.KeyStore;
import java.security.Security;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.conscrypt.Conscrypt;
import org.conscrypt.OpenSSLProvider;

public class HttpClientBuilderImpl
implements HttpClient.Builder {
    private KeyStore trustStore;
    private KeyStore keyStore;
    private String keyPassword;
    private Duration connectTimeout;
    private boolean followRedirects = false;
    private String name = "HttpClient";
    private static volatile boolean securityProviderAdded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addSecurityProvider() {
        if (securityProviderAdded) return;
        Class<HttpClientBuilderImpl> clazz = HttpClientBuilderImpl.class;
        synchronized (HttpClientBuilderImpl.class) {
            if (securityProviderAdded) return;
            if (Security.getProvider("Conscrypt") == null) {
                Security.addProvider(new OpenSSLProvider());
            }
            securityProviderAdded = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public HttpClient.Builder trustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
        return this;
    }

    @Override
    public HttpClient.Builder keyStore(KeyStore keyStore, String keyPassword) {
        this.keyStore = keyStore;
        this.keyPassword = keyPassword;
        return this;
    }

    @Override
    public HttpClient.Builder connectTimeout(Duration duration) {
        Objects.requireNonNull(duration);
        if (duration.isNegative() || duration.isZero()) {
            throw new IllegalArgumentException("Invalid duration: " + duration);
        }
        this.connectTimeout = duration;
        return this;
    }

    @Override
    public HttpClient.Builder followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    @Override
    public HttpClient.Builder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public HttpClient build() {
        HttpClientBuilderImpl.addSecurityProvider();
        DefaultHostnameVerifier defaultHostnameVerifier = new DefaultHostnameVerifier();
        Conscrypt.setDefaultHostnameVerifier(defaultHostnameVerifier::verify);
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        sslContextFactory.setProvider("Conscrypt");
        if (this.trustStore != null) {
            sslContextFactory.setTrustStore(this.trustStore);
        }
        if (this.keyStore != null) {
            sslContextFactory.setKeyStore(this.keyStore);
        }
        if (this.keyPassword != null) {
            sslContextFactory.setKeyManagerPassword(this.keyPassword);
        }
        HTTP2Client http2Client = new HTTP2Client();
        http2Client.addBean(sslContextFactory);
        HttpClientTransportOverHTTP2 clientTransport = new HttpClientTransportOverHTTP2(http2Client);
        de.mklinger.qetcher.client.jetty.client.HttpClient jettyClient = new de.mklinger.qetcher.client.jetty.client.HttpClient(clientTransport, sslContextFactory);
        if (this.connectTimeout != null) {
            long timeoutMillis = this.connectTimeout.toMillis();
            jettyClient.setConnectTimeout(timeoutMillis);
            if (timeoutMillis < jettyClient.getAddressResolutionTimeout()) {
                jettyClient.setAddressResolutionTimeout(timeoutMillis);
            }
        }
        jettyClient.setFollowRedirects(this.followRedirects);
        jettyClient.setExecutor(this.newExecutor(this.getClass().getClassLoader(), this.name));
        try {
            jettyClient.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new JettyHttpClient(jettyClient);
    }

    private Executor newExecutor(ClassLoader classLoader, String name) {
        ThreadContextClassLoaderQueuedThreadPool threadPool = new ThreadContextClassLoaderQueuedThreadPool(classLoader);
        threadPool.setName(name);
        return threadPool;
    }
}

