/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.throwables;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;

public class Throwables {
    private Throwables() {
    }

    public static String stackTraceToString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static <T> Optional<T> firstCause(Throwable e, Class<T> errorType) {
        if (e == null) {
            return Optional.empty();
        }
        if (errorType.isAssignableFrom(e.getClass())) {
            return Optional.of(errorType.cast(e));
        }
        return Throwables.firstCause(e.getCause(), errorType);
    }

    public static boolean hasCause(Throwable e, Class<?> errorType) {
        return Throwables.firstCause(e, errorType).isPresent();
    }
}

