/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.model.v1.builder;

import de.mklinger.qetcher.client.model.v1.NodeAddress;
import de.mklinger.qetcher.client.model.v1.impl.NodeAddressImpl;

public class NodeAddressBuilder {
    private String host;
    private int port;

    public static NodeAddressBuilder of(NodeAddress nodeAddress) {
        return new NodeAddressBuilder().host(nodeAddress.getHost()).port(nodeAddress.getPort());
    }

    public NodeAddressBuilder address(String address) {
        int port;
        int idx = address.lastIndexOf(":");
        if (idx <= 0 || idx == address.length() - 1) {
            throw new IllegalArgumentException("Cannot parse address string: '" + address + "'");
        }
        String host = address.substring(0, idx);
        if (host.startsWith("[")) {
            if (!host.endsWith("]") || host.length() <= 2) {
                throw new IllegalArgumentException("Cannot parse address string host part: '" + address + "'");
            }
            host = host.substring(1, host.length() - 1);
        }
        try {
            port = Integer.parseInt(address.substring(idx + 1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot parse address string port part: '" + address + "'");
        }
        return this.host(host).port(port);
    }

    public NodeAddressBuilder host(String host) {
        this.host = host;
        return this;
    }

    public NodeAddressBuilder port(int port) {
        this.port = port;
        return this;
    }

    public NodeAddress build() {
        return new NodeAddressImpl(this);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

