/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.impl;

import de.mklinger.qetcher.client.InputConversionFile;
import de.mklinger.qetcher.client.InputJob;
import de.mklinger.qetcher.client.impl.InputJobBuilderImpl;
import de.mklinger.qetcher.client.model.v1.MediaType;
import java.time.Duration;
import java.util.List;
import java.util.Objects;

public class InputJobImpl
implements InputJob {
    private final List<String> conversionFileIds;
    private final InputConversionFile inputConversionFile;
    private final MediaType toMediaType;
    private final MediaType fromMediaType;
    private final Duration deleteTimeout;
    private final Duration cancelTimeout;
    private final String referrer;

    public InputJobImpl(InputJobBuilderImpl builder) {
        this.conversionFileIds = builder.getConversionFileIds();
        this.inputConversionFile = builder.getInputConversionFile();
        this.toMediaType = Objects.requireNonNull(builder.getToMediaType(), "Missing toMediaType");
        this.fromMediaType = builder.getFromMediaType();
        this.deleteTimeout = builder.getDeleteTimeout();
        this.cancelTimeout = builder.getCancelTimeout();
        this.referrer = builder.getReferrer();
        if (this.conversionFileIds == null && this.inputConversionFile == null || this.conversionFileIds != null && this.inputConversionFile != null) {
            throw new IllegalArgumentException("Exactly one of conversionFileIds and inputConversionFile must be set");
        }
        if (this.fromMediaType == null && this.inputConversionFile == null) {
            throw new IllegalArgumentException("fromMediaType must be given when inputConversionFile is not set");
        }
        if (this.fromMediaType != null && this.inputConversionFile != null) {
            throw new IllegalArgumentException("fromMediaType must not be given when inputConversionFile is set");
        }
    }

    @Override
    public List<String> getConversionFileIds() {
        return this.conversionFileIds;
    }

    @Override
    public InputConversionFile getInputConversionFile() {
        return this.inputConversionFile;
    }

    @Override
    public MediaType getFromMediaType() {
        if (this.fromMediaType == null) {
            return this.inputConversionFile.getMediaType();
        }
        return this.fromMediaType;
    }

    @Override
    public MediaType getToMediaType() {
        return this.toMediaType;
    }

    @Override
    public Duration getDeleteTimeout() {
        if (this.deleteTimeout == null && this.inputConversionFile != null) {
            return this.inputConversionFile.getDeleteTimeout();
        }
        return this.deleteTimeout;
    }

    @Override
    public Duration getCancelTimeout() {
        return this.cancelTimeout;
    }

    @Override
    public String getReferrer() {
        return this.referrer;
    }
}

