/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.httpclient.internal;

import de.mklinger.qetcher.client.httpclient.HttpRequest;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBodyProvider
implements HttpRequest.BodyProvider {
    private static final int CHUNK_SIZE = 102400;
    private static final Logger LOG = LoggerFactory.getLogger(FileBodyProvider.class);
    private final Path file;

    public FileBodyProvider(Path file) {
        this.file = file;
    }

    @Override
    public Iterator<CompletableFuture<ByteBuffer>> iterator() {
        try {
            try {
                AsynchronousFileChannel channel = AsynchronousFileChannel.open(this.file, StandardOpenOption.READ);
                return new AsynchronousFileChannelIterator(channel);
            }
            catch (UnsupportedOperationException e) {
                LOG.info("Falling back to blocking file channel to read from {}", (Object)this.file);
                FileChannel channel = FileChannel.open(this.file, StandardOpenOption.READ);
                return new FileChannelIterator(channel);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long contentLength() {
        try {
            return Files.size(this.file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class FileChannelIterator
    implements Iterator<CompletableFuture<ByteBuffer>> {
        private final FileChannel channel;
        private final AtomicBoolean reading;

        private FileChannelIterator(FileChannel channel) {
            this.channel = channel;
            this.reading = new AtomicBoolean(false);
        }

        @Override
        public boolean hasNext() {
            if (this.reading.get()) {
                throw new IllegalStateException("Reading in progress");
            }
            try {
                boolean hasNext;
                boolean bl = hasNext = this.channel.isOpen() && this.channel.position() < this.channel.size();
                if (!hasNext) {
                    LOG.debug("Closing channel in hasNext()");
                    this.channel.close();
                }
                return hasNext;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public CompletableFuture<ByteBuffer> next() {
            if (!this.reading.compareAndSet(false, true)) {
                throw new IllegalStateException("Reading in progress");
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(102400);
            try {
                this.channel.read(byteBuffer);
                byteBuffer.flip();
                this.unsetReading();
            }
            catch (Throwable e) {
                this.closeChannelAndRethrowUncheckedAfterRead(e);
            }
            return CompletableFuture.completedFuture(byteBuffer);
        }

        private void closeChannelAndRethrowUncheckedAfterRead(Throwable e1) {
            RuntimeException ex = e1 instanceof IOException ? new UncheckedIOException((IOException)e1) : new RuntimeException(e1);
            try {
                this.channel.close();
            }
            catch (Throwable e2) {
                ex.addSuppressed(e2);
            }
            try {
                this.unsetReading();
            }
            catch (Throwable e2) {
                ex.addSuppressed(e2);
            }
            throw ex;
        }

        private void unsetReading() {
            if (!this.reading.compareAndSet(true, false)) {
                throw new IllegalStateException("Reading was not in progress");
            }
        }
    }

    private static class AsynchronousFileChannelIterator
    implements Iterator<CompletableFuture<ByteBuffer>> {
        private final AsynchronousFileChannel channel;
        private final AtomicLong position;
        private final AtomicBoolean reading;

        private AsynchronousFileChannelIterator(AsynchronousFileChannel channel) {
            this.channel = channel;
            this.position = new AtomicLong(0L);
            this.reading = new AtomicBoolean(false);
        }

        @Override
        public boolean hasNext() {
            if (this.reading.get()) {
                throw new IllegalStateException("Reading in progress");
            }
            try {
                boolean hasNext;
                boolean bl = hasNext = this.channel.isOpen() && this.position.get() < this.channel.size();
                if (!hasNext) {
                    LOG.debug("Closing channel in hasNext()");
                    this.channel.close();
                }
                return hasNext;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public CompletableFuture<ByteBuffer> next() {
            if (!this.reading.compareAndSet(false, true)) {
                throw new IllegalStateException("Reading in progress");
            }
            CompletableFuture<ByteBuffer> cf = new CompletableFuture<ByteBuffer>();
            ByteBuffer byteBuffer = ByteBuffer.allocate(102400);
            LOG.debug("Start reading chunk at position {}", (Object)this.position.get());
            this.readChannel(byteBuffer, this.position.get(), result -> this.handleReadResult(cf, byteBuffer, result), error -> this.closeChannelOnError(cf, (Throwable)error));
            return cf;
        }

        private void readChannel(ByteBuffer byteBuffer, long position, final IntConsumer onCompleted, final Consumer<Throwable> onFailed) {
            this.channel.read(byteBuffer, position, null, new CompletionHandler<Integer, Void>(){

                @Override
                public void completed(Integer result, Void attachment) {
                    onCompleted.accept(result);
                }

                @Override
                public void failed(Throwable exc, Void attachment) {
                    onFailed.accept(exc);
                }
            });
        }

        private void handleReadResult(CompletableFuture<ByteBuffer> cf, ByteBuffer byteBuffer, int result) {
            try {
                LOG.debug("Done reading chunk at position {}", (Object)this.position.get());
                if (!this.reading.compareAndSet(true, false)) {
                    throw new IllegalStateException("Reading was not in progress");
                }
                LOG.debug("Result: {}", (Object)result);
                if (result == -1) {
                    throw new IOException("Unable to read another chunk");
                }
                byteBuffer.flip();
                int remaining = byteBuffer.remaining();
                this.position.addAndGet(remaining);
                LOG.debug("Read {} bytes from file", (Object)remaining);
                assert (remaining == result);
                cf.complete(byteBuffer);
            }
            catch (Throwable e) {
                this.closeChannelOnError(cf, e);
            }
        }

        private void closeChannelOnError(CompletableFuture<?> cf, Throwable error) {
            Throwable e = error;
            try {
                LOG.debug("Closing channel on error");
                this.channel.close();
            }
            catch (Throwable ex) {
                if (e == null) {
                    e = ex;
                }
                e.addSuppressed(ex);
            }
            cf.completeExceptionally(e);
        }
    }
}

