package de.mklinger.qetcher.client.model.v1.impl;

import de.mklinger.qetcher.client.model.v1.NodeAddress;
import de.mklinger.qetcher.client.model.v1.builder.NodeAddressBuilder;

/**
 * A transport address used for IP socket address.
 */
public final class NodeAddressImpl implements NodeAddress {

	private final String host;
	private final int port;

	private NodeAddressImpl(final String host, final int port) {
		if (host == null || host.isEmpty()) {
			throw new IllegalArgumentException("Host is required");
		}
		if (port <= 0) {
			throw new IllegalArgumentException("Port must be > 0");
		}
		this.host = host;
		this.port = port;
	}

	public NodeAddressImpl(final NodeAddressBuilder builder) {
		this(builder.getHost(), builder.getPort());
	}

	@Override
	public int getPort() {
		return port;
	}

	@Override
	public String getHost() {
		return host;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((host == null) ? 0 : host.hashCode());
		result = prime * result + port;
		return result;
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final NodeAddressImpl other = (NodeAddressImpl) obj;
		if (host == null) {
			if (other.host != null) {
				return false;
			}
		} else if (!host.equals(other.host)) {
			return false;
		}
		if (port != other.port) {
			return false;
		}
		return true;
	}

	@Override
	public String toString() {
		return toUriString();
	}

	@Override
	public String toUriString() {
		return toHostUriString() + ":" + port;
	}

	@Override
	public String toHostUriString() {
		if (host.contains(":")) {
			// IPv6
			return "[" + host + "]";
		} else {
			return host;
		}
	}
}
