package de.mklinger.qetcher.client.model.v1.builder;

import java.util.List;

import de.mklinger.qetcher.client.model.v1.AvailableNode;
import de.mklinger.qetcher.client.model.v1.AvailableNodes;
import de.mklinger.qetcher.client.model.v1.impl.AvailableNodesImpl;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class AvailableNodesBuilder {
	private List<AvailableNode> availableNodes;

	public static AvailableNodesBuilder of(final AvailableNodes availableNodes) {
		return new AvailableNodesBuilder()
				.availableNodes(availableNodes.getAvailableNodes());
	}

	public List<AvailableNode> getAvailableNodes() {
		return availableNodes;
	}

	public AvailableNodesBuilder availableNodes(final List<AvailableNode> availableNodes) {
		this.availableNodes = availableNodes;
		return this;
	}

	public AvailableNodes build() {
		return new AvailableNodesImpl(this);
	}
}
