package de.mklinger.qetcher.client.model.v1;

import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.util.List;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public interface ConversionFile {
	String getFileId();

	boolean isServiceManaged();

	String getTenantId();

	String getName();

	BigInteger getSize();

	MediaType getMediaType();

	/**
	 * List of node ids, where this file is physically available.
	 */
	List<String> getNodeIds();

	Instant getCreated();

	Instant getUpdated();

	Duration getDeleteTimeout();
}