package de.mklinger.qetcher.client.impl.retry;

import de.mklinger.qetcher.client.QetcherRemoteException;

/**
 * Exception uses as a marker to not do retries when retrying already failed on
 * a nested call.
 *
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class RetryFailedQetcherRemoteException extends QetcherRemoteException implements RetryFailedException {
	private static final long serialVersionUID = 1L;

	public RetryFailedQetcherRemoteException(final QetcherRemoteException cause) {
		super(cause.getError(), cause.getStatusCode());
		super.initCause(cause);
	}
}
