package de.mklinger.qetcher.client;

import java.io.File;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.AvailableNode;
import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.FileExtensionInfos;
import de.mklinger.qetcher.client.model.v1.Job;
import de.mklinger.qetcher.client.model.v1.MediaTypeInfo;

/**
 * The Qetcher client.
 *
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public interface QetcherClient extends AutoCloseable {
	CompletableFuture<ConversionFile> uploadFile(InputConversionFile inputFile);
	CompletableFuture<ConversionFile> getFile(String fileId);
	CompletableFuture<List<ConversionFile>> getFiles();
	CompletableFuture<Void> deleteFile(String fileId);
	CompletableFuture<Path> downloadAsFile(String fileId, Path file, OpenOption... openOptions);

	CompletableFuture<Job> createJob(InputJob inputJob);
	CompletableFuture<Job> getJob(String jobId);
	CompletableFuture<List<Job>> getJobs();
	CompletableFuture<Void> cancelJob(String jobId);
	CompletableFuture<Void> deleteJob(String jobId);

	CompletableFuture<List<AvailableConversion>> getAvailableConversions();
	CompletableFuture<List<MediaTypeInfo>> getMediaTypes();
	CompletableFuture<FileExtensionInfos> getFileExtensions();
	CompletableFuture<MediaTypeInfo> getMediaTypeForFilename(String filename);

	CompletableFuture<List<AvailableNode>> getAvailableNodes();

	CompletableFuture<ConversionFile> getFile(final ConversionFile file);

	CompletableFuture<Void> deleteFile(final ConversionFile file);

	CompletableFuture<Path> downloadAsFile(final String fileId, final Path file);

	CompletableFuture<File> downloadAsFile(final String fileId, final File file);

	CompletableFuture<Path> downloadAsTempFile(final String fileId);

	CompletableFuture<Path> downloadAsTempFile(final String fileId, final Path dir);

	CompletableFuture<Job> getJob(final Job job);

	CompletableFuture<Void> deleteJob(final Job job);

	CompletableFuture<Job> getJobDone(final Job job);

	CompletableFuture<Job> getJobDone(final String jobId);

	@Override
	void close();

	public interface Builder {
		Builder serviceAddresses(String... serviceAddresses);
		Builder withServiceAddress(String serviceAddress);
		Builder withServiceAddress(String host, int port);
		Builder disableServiceLookup();
		Builder trustStore(KeyStore trustStore);
		Builder keyStore(KeyStore keyStore, String keyPassword);
		QetcherClient build();
	}
}
