/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.httpclient.internal.jetty;

import de.mklinger.qetcher.client.httpclient.HttpHeaders;
import de.mklinger.qetcher.client.httpclient.HttpResponse;
import de.mklinger.qetcher.client.httpclient.internal.jetty.BodyResult;
import de.mklinger.qetcher.client.httpclient.internal.jetty.HeadersTransformation;
import de.mklinger.qetcher.client.jetty.client.api.Response;
import de.mklinger.qetcher.client.jetty.client.api.Result;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullCompleteListener<T>
extends Response.Listener.Adapter {
    private static final Logger LOG = LoggerFactory.getLogger(FullCompleteListener.class);
    private final Executor completionExecutor;
    private final CompletableFuture<BodyResult<T>> result;
    private final HttpResponse.BodyHandler<T> responseBodyHandler;
    private volatile HttpResponse.BodyCompleteListener<T> bodyCompleteListener;

    public FullCompleteListener(Executor completionExecutor, HttpResponse.BodyHandler<T> responseBodyHandler) {
        this.completionExecutor = completionExecutor;
        this.result = new CompletableFuture();
        this.responseBodyHandler = responseBodyHandler;
    }

    @Override
    public void onHeaders(Response response) {
        int statusCode = response.getStatus();
        HttpHeaders responseHeaders = HeadersTransformation.toHttpHeaders(response.getHeaders());
        LOG.debug("Response: Have headers, setting up body handling");
        LOG.debug("Headers: {}", responseHeaders.map());
        try {
            this.bodyCompleteListener = this.responseBodyHandler.apply(statusCode, responseHeaders);
        }
        catch (Throwable e) {
            this.handleError(response, e);
        }
    }

    @Override
    public void onContent(Response response, ByteBuffer content) {
        try {
            this.bodyCompleteListener.onNext(content);
        }
        catch (Throwable e) {
            this.handleError(response, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete(Result result) {
        try {
            Throwable resultFailure = result.getFailure();
            if (resultFailure != null) {
                this.handleError(null, resultFailure);
            } else {
                try {
                    this.bodyCompleteListener.onComplete();
                    this.complete(new BodyResult<T>(result, this.bodyCompleteListener.getBody()));
                }
                catch (Throwable e) {
                    this.handleError(null, e);
                }
            }
        }
        finally {
            HttpResponse.BodyCompleteListener<T> l = this.bodyCompleteListener;
            this.bodyCompleteListener = null;
            if (l != null) {
                try {
                    l.close();
                }
                catch (Throwable e) {
                    this.completeExceptionally(e);
                }
            }
        }
    }

    private void handleError(Response response, Throwable e) {
        HttpResponse.BodyCompleteListener<T> l = this.bodyCompleteListener;
        this.bodyCompleteListener = null;
        if (l != null) {
            try {
                l.close();
            }
            catch (Throwable suppressed) {
                e.addSuppressed(suppressed);
            }
        }
        if (response != null) {
            try {
                response.abort(e);
            }
            catch (Throwable suppressed) {
                e.addSuppressed(suppressed);
            }
        }
        try {
            this.completeExceptionally(e);
        }
        catch (Throwable suppressed) {
            e.addSuppressed(suppressed);
        }
        LOG.debug("Error in complete listener", e);
    }

    private void complete(BodyResult<T> bodyResult) {
        this.completionExecutor.execute(() -> this.result.complete(bodyResult));
    }

    private void completeExceptionally(Throwable e) {
        this.completionExecutor.execute(() -> this.result.completeExceptionally(e));
    }

    public CompletableFuture<BodyResult<T>> getResult() {
        return this.result;
    }
}

